/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.intent.matcher;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.test.core.app.ApplicationProvider;
import androidx.test.espresso.intent.Checks;
import androidx.test.espresso.intent.ResolvedIntent;
import androidx.test.espresso.intent.matcher.BundleMatchers;
import androidx.test.espresso.intent.matcher.ComponentNameMatchers;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.Set;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;

@CheckReturnValue
public final class IntentMatchers {
    private IntentMatchers() {
    }

    public static Matcher<Intent> anyIntent() {
        return new TypeSafeMatcher<Intent>(){

            public void describeTo(Description description) {
                description.appendText("any intent");
            }

            public boolean matchesSafely(Intent intent) {
                return true;
            }
        };
    }

    public static Matcher<Intent> hasAction(String action) {
        return IntentMatchers.hasAction((Matcher<String>)Matchers.is((Object)action));
    }

    public static Matcher<Intent> hasAction(final Matcher<String> actionMatcher) {
        Checks.checkNotNull(actionMatcher);
        return new TypeSafeMatcher<Intent>(){

            public void describeTo(Description description) {
                description.appendText("has action: ");
                description.appendDescriptionOf((SelfDescribing)actionMatcher);
            }

            public boolean matchesSafely(Intent intent) {
                return actionMatcher.matches((Object)intent.getAction());
            }
        };
    }

    public static Matcher<Intent> hasCategories(Set<String> categories) {
        return IntentMatchers.hasCategories((Matcher<? extends Iterable<? super String>>)Matchers.equalTo(categories));
    }

    public static Matcher<Intent> hasCategories(final Matcher<? extends Iterable<? super String>> categoriesMatcher) {
        Checks.checkNotNull(categoriesMatcher);
        return new TypeSafeMatcher<Intent>(){

            public void describeTo(Description description) {
                description.appendText("has categories: ");
                description.appendDescriptionOf((SelfDescribing)categoriesMatcher);
            }

            public boolean matchesSafely(Intent intent) {
                return categoriesMatcher.matches((Object)intent.getCategories());
            }
        };
    }

    public static Matcher<Intent> hasComponent(String className) {
        return IntentMatchers.hasComponent(ComponentNameMatchers.hasClassName(className));
    }

    public static Matcher<Intent> hasComponent(ComponentName componentName) {
        return IntentMatchers.hasComponent(ComponentNameMatchers.hasClassName(componentName.getClassName()));
    }

    public static Matcher<Intent> hasComponent(final Matcher<ComponentName> componentMatcher) {
        Checks.checkNotNull(componentMatcher);
        return new TypeSafeMatcher<Intent>(){

            public void describeTo(Description description) {
                description.appendText("has component: ");
                description.appendDescriptionOf((SelfDescribing)componentMatcher);
            }

            public boolean matchesSafely(Intent intent) {
                return componentMatcher.matches((Object)intent.getComponent());
            }
        };
    }

    public static Matcher<Intent> hasData(String uri) {
        return IntentMatchers.hasData((Matcher<Uri>)Matchers.is((Object)Uri.parse((String)uri)));
    }

    public static Matcher<Intent> hasData(Uri uri) {
        return IntentMatchers.hasData((Matcher<Uri>)Matchers.is((Object)uri));
    }

    public static Matcher<Intent> hasData(final Matcher<Uri> uriMatcher) {
        Checks.checkNotNull(uriMatcher);
        return new TypeSafeMatcher<Intent>(){

            public void describeTo(Description description) {
                description.appendText("has data: ");
                description.appendDescriptionOf((SelfDescribing)uriMatcher);
            }

            public boolean matchesSafely(Intent intent) {
                return uriMatcher.matches((Object)intent.getData());
            }
        };
    }

    public static Matcher<Intent> hasDataString(final Matcher<String> stringMatcher) {
        Checks.checkNotNull(stringMatcher);
        return new TypeSafeMatcher<Intent>(){

            public void describeTo(Description description) {
                description.appendText("has data string: ").appendDescriptionOf((SelfDescribing)stringMatcher);
            }

            public boolean matchesSafely(Intent intent) {
                return stringMatcher.matches((Object)intent.getDataString());
            }
        };
    }

    public static Matcher<Intent> hasExtraWithKey(String key) {
        return IntentMatchers.hasExtraWithKey((Matcher<String>)Matchers.is((Object)key));
    }

    public static Matcher<Intent> hasExtraWithKey(Matcher<String> keyMatcher) {
        return IntentMatchers.hasExtras(BundleMatchers.hasKey(keyMatcher));
    }

    @NonNull
    public static Matcher<Intent> doesNotHaveExtraWithKey(@NonNull String key) {
        return IntentMatchers.doesNotHaveExtraWithKey((Matcher<String>)Matchers.is((Object)key));
    }

    @NonNull
    public static Matcher<Intent> doesNotHaveExtraWithKey(@NonNull Matcher<String> keyMatcher) {
        return IntentMatchers.hasExtras(BundleMatchers.doesNotHaveKey(keyMatcher));
    }

    public static <T> Matcher<Intent> hasExtra(String key, T value) {
        return IntentMatchers.hasExtras(BundleMatchers.hasEntry(key, value));
    }

    public static Matcher<Intent> hasExtra(String key, Matcher<?> valueMatcher) {
        return IntentMatchers.hasExtras(BundleMatchers.hasEntry(key, valueMatcher == null ? Matchers.nullValue() : valueMatcher));
    }

    public static Matcher<Intent> hasExtra(Matcher<String> keyMatcher, Matcher<?> valueMatcher) {
        return IntentMatchers.hasExtras(BundleMatchers.hasEntry(keyMatcher, valueMatcher));
    }

    public static Matcher<Intent> hasExtras(final Matcher<Bundle> bundleMatcher) {
        Checks.checkNotNull(bundleMatcher);
        return new TypeSafeMatcher<Intent>(){

            public void describeTo(Description description) {
                description.appendText("has extras: ");
                description.appendDescriptionOf((SelfDescribing)bundleMatcher);
            }

            public boolean matchesSafely(Intent intent) {
                return bundleMatcher.matches((Object)intent.getExtras());
            }
        };
    }

    public static Matcher<Intent> hasType(String type) {
        return IntentMatchers.hasType((Matcher<String>)Matchers.is((Object)type));
    }

    public static Matcher<Intent> hasType(final Matcher<String> typeMatcher) {
        Checks.checkNotNull(typeMatcher);
        return new TypeSafeMatcher<Intent>(){

            public void describeTo(Description description) {
                description.appendText("has type: ");
                description.appendDescriptionOf((SelfDescribing)typeMatcher);
            }

            public boolean matchesSafely(Intent intent) {
                return typeMatcher.matches((Object)intent.getType());
            }
        };
    }

    public static Matcher<Intent> hasPackage(final Matcher<String> packageMatcher) {
        Checks.checkNotNull(packageMatcher);
        return new TypeSafeMatcher<Intent>(){

            public void describeTo(Description description) {
                description.appendText("has pkg: ");
                description.appendDescriptionOf((SelfDescribing)packageMatcher);
            }

            public boolean matchesSafely(Intent intent) {
                return packageMatcher.matches((Object)intent.getPackage());
            }
        };
    }

    public static Matcher<Intent> hasPackage(String packageName) {
        Checks.checkNotNull(packageName);
        return IntentMatchers.hasPackage((Matcher<String>)Matchers.equalTo((Object)packageName));
    }

    public static Matcher<Intent> toPackage(final String packageName) {
        Checks.checkNotNull(packageName);
        return new TypeSafeMatcher<Intent>(){

            public void describeTo(Description description) {
                description.appendText("resolvesTo: " + packageName);
            }

            public boolean matchesSafely(Intent intent) {
                if (!(intent instanceof ResolvedIntent)) {
                    throw new RuntimeException(String.format("toPackage.matches was given an intent that is not of type %s. This should not happen as this method is only invoked internally by Intents.", ResolvedIntent.class.getSimpleName()));
                }
                return ((ResolvedIntent)intent).canBeHandledBy(packageName);
            }
        };
    }

    public static Matcher<Intent> hasFlag(int flag) {
        return IntentMatchers.hasFlags(flag);
    }

    public static Matcher<Intent> hasFlags(int ... flags) {
        int allFlags = 0;
        for (int i : flags) {
            allFlags |= i;
        }
        return IntentMatchers.hasFlags(allFlags);
    }

    public static Matcher<Intent> hasFlags(final int flags) {
        return new TypeSafeMatcher<Intent>(){

            public void describeTo(Description description) {
                description.appendText("flags: " + Integer.toHexString(flags));
            }

            public boolean matchesSafely(Intent intent) {
                int intentFlags = intent.getFlags();
                return (intentFlags & flags) == flags;
            }
        };
    }

    public static Matcher<Intent> filterEquals(final Intent expectedIntent) {
        return new TypeSafeMatcher<Intent>(){

            public void describeTo(Description description) {
                description.appendText("filterEquals: ").appendValue((Object)expectedIntent);
            }

            public boolean matchesSafely(Intent intent) {
                return expectedIntent.filterEquals(intent);
            }
        };
    }

    public static Matcher<Intent> isInternal() {
        final Context targetContext = ApplicationProvider.getApplicationContext();
        return new TypeSafeMatcher<Intent>(){

            public void describeTo(Description description) {
                description.appendText("target package: " + targetContext.getPackageName());
            }

            public boolean matchesSafely(Intent intent) {
                ComponentName component = intent.resolveActivity(targetContext.getPackageManager());
                if (component != null) {
                    return ComponentNameMatchers.hasMyPackageName().matches((Object)component);
                }
                return false;
            }
        };
    }
}

