/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.action;

import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import android.view.View;
import android.webkit.WebView;
import androidx.annotation.Nullable;
import androidx.concurrent.futures.ResolvableFuture;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.Bindable;
import androidx.test.espresso.web.action.IAtomActionResultPropagator;
import androidx.test.espresso.web.action.JavascriptEvaluation;
import androidx.test.espresso.web.model.Atom;
import androidx.test.espresso.web.model.ElementReference;
import androidx.test.espresso.web.model.Evaluation;
import androidx.test.espresso.web.model.WindowReference;
import androidx.test.espresso.web.util.concurrent.Futures;
import androidx.test.internal.util.Checks;
import androidx.test.platform.concurrent.DirectExecutor;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.jvm.functions.Function1;
import org.hamcrest.Matcher;

public final class AtomAction<E>
implements ViewAction,
Bindable {
    private static final String TAG = "AtomAction";
    private static final String ID = "AtomAction";
    private static final String EVALUATION_ERROR_KEY = "evaluation_error_key";
    private final ResolvableFuture<Evaluation> futureEval = ResolvableFuture.create();
    final Atom<E> atom;
    @Nullable
    final WindowReference window;
    @Nullable
    final ElementReference element;
    private IAtomActionResultPropagator atomActionResultPropagator = new IAtomActionResultPropagator.Stub(){

        @Override
        public void setResult(Evaluation evaluation) throws RemoteException {
            AtomAction.this.futureEval.set((Object)evaluation);
        }

        @Override
        public void setError(Bundle bundle) throws RemoteException {
            Throwable evalError = (Throwable)bundle.getSerializable(AtomAction.EVALUATION_ERROR_KEY);
            AtomAction.this.futureEval.setException(evalError);
        }
    };

    public AtomAction(Atom<E> atom, @Nullable WindowReference window, @Nullable ElementReference element) {
        this.atom = (Atom)Checks.checkNotNull(atom);
        this.window = window;
        this.element = element;
    }

    public Matcher<View> getConstraints() {
        return ViewMatchers.isJavascriptEnabled();
    }

    public String getDescription() {
        return String.format("Evaluate Atom: %s in window: %s with element: %s", this.atom, this.window, this.element);
    }

    public void perform(UiController uiController, View view) {
        WebView webView = (WebView)view;
        if (Build.VERSION.SDK_INT >= 23 && !webView.isHardwareAccelerated()) {
            throw new PerformException.Builder().withViewDescription(webView.toString()).withCause((Throwable)new RuntimeException("Hardware acceleration is not supported on current device")).build();
        }
        List arguments = (List)Checks.checkNotNull(this.atom.getArguments(this.element));
        String script = (String)Checks.checkNotNull((Object)this.atom.getScript());
        final ListenableFuture<Evaluation> localEval = JavascriptEvaluation.evaluate(webView, script, arguments, this.window);
        if (null != this.window && Build.VERSION.SDK_INT == 19) {
            Log.w((String)"AtomAction", (String)"WARNING: KitKat does not report when an iframe is loading new content. If you are interacting with content within an iframe and that content is changing (eg: you have just pressed a submit button). Espresso will not be able to block you until the new content has loaded (which it can do on all other API levels). You will need to have some custom polling / synchronization with the iframe in that case.");
        }
        localEval.addListener(new Runnable(){

            @Override
            public void run() {
                try {
                    AtomAction.this.atomActionResultPropagator.setResult((Evaluation)localEval.get());
                }
                catch (ExecutionException ee) {
                    AtomAction.this.reportException(ee.getCause());
                }
                catch (InterruptedException ie) {
                    AtomAction.this.reportException(ie);
                }
                catch (RemoteException re) {
                    AtomAction.this.reportException(re);
                }
            }
        }, (Executor)DirectExecutor.INSTANCE);
    }

    private void reportException(Throwable throwable) {
        Bundle errorBundle = new Bundle();
        errorBundle.putSerializable(EVALUATION_ERROR_KEY, (Serializable)throwable);
        try {
            this.atomActionResultPropagator.setError(errorBundle);
        }
        catch (RemoteException re) {
            Log.e((String)"AtomAction", (String)"Cannot report error to result propagator", (Throwable)re);
        }
    }

    public Future<E> getFuture() {
        return Futures.transform(this.futureEval, new Function1<Evaluation, E>(){

            public E invoke(Evaluation e) {
                return AtomAction.this.atom.transform(e);
            }
        }, (Executor)DirectExecutor.INSTANCE);
    }

    public E get() throws ExecutionException, InterruptedException {
        Checks.checkState((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"On main thread!");
        return this.getFuture().get();
    }

    public E get(long val, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        Checks.checkState((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"On main thread!");
        return this.getFuture().get(val, unit);
    }

    public String getId() {
        return "AtomAction";
    }

    public IBinder getIBinder() {
        return this.atomActionResultPropagator.asBinder();
    }

    public void setIBinder(IBinder binder) {
        this.atomActionResultPropagator = IAtomActionResultPropagator.Stub.asInterface(binder);
    }
}

