/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.assertion;

import androidx.test.internal.util.Checks;
import java.io.IOException;
import java.io.StringBufferInputStream;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.ccil.cowan.tagsoup.Parser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public final class TagSoupDocumentParser {
    private static final ThreadLocal<TransformerFactory> transformerFactory = new ThreadLocal<TransformerFactory>(){

        @Override
        protected TransformerFactory initialValue() {
            return TransformerFactory.newInstance();
        }
    };
    private final Parser parser = new Parser();

    private TagSoupDocumentParser() throws SAXNotRecognizedException, SAXNotSupportedException {
        this.parser.setFeature("http://xml.org/sax/features/namespaces", false);
    }

    public static TagSoupDocumentParser newInstance() throws SAXNotRecognizedException, SAXNotSupportedException {
        return new TagSoupDocumentParser();
    }

    public Document parse(String html) throws SAXException, IOException {
        Checks.checkNotNull((Object)html);
        SAXSource in = new SAXSource((XMLReader)this.parser, new InputSource(new StringBufferInputStream(html)));
        DOMResult out = new DOMResult();
        try {
            transformerFactory.get().newTransformer().transform(in, out);
        }
        catch (TransformerException e) {
            throw new SAXException(e);
        }
        return (Document)out.getNode();
    }
}

