/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.assertion;

import android.view.View;
import android.webkit.WebView;
import androidx.annotation.VisibleForTesting;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.web.model.Atom;
import androidx.test.internal.util.Checks;

public abstract class WebAssertion<E> {
    @RemoteMsgField(order=0)
    private final Atom<E> atom;

    @RemoteMsgConstructor
    public WebAssertion(Atom<E> atom) {
        this.atom = (Atom)Checks.checkNotNull(atom);
    }

    public final Atom<E> getAtom() {
        return this.atom;
    }

    public final ViewAssertion toViewAssertion(E result) {
        return new CheckResultWebAssertion<Object>(Checks.checkNotNull(result), this);
    }

    protected abstract void checkResult(WebView var1, E var2);

    @VisibleForTesting
    static final class CheckResultWebAssertion<T>
    implements ViewAssertion {
        final T result;
        final WebAssertion<T> webAssertion;

        CheckResultWebAssertion(T result, WebAssertion<T> webAssertion) {
            this.result = result;
            this.webAssertion = webAssertion;
        }

        public void check(View view, NoMatchingViewException noViewFoundException) {
            if (null == view) {
                throw noViewFoundException;
            }
            if (!(view instanceof WebView)) {
                throw new RuntimeException(view + ": is not a WebView!");
            }
            this.webAssertion.checkResult((WebView)view, this.result);
        }
    }
}

