/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.assertion;

import android.webkit.WebView;
import androidx.annotation.VisibleForTesting;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.web.assertion.TagSoupDocumentParser;
import androidx.test.espresso.web.assertion.WebAssertion;
import androidx.test.espresso.web.model.Atom;
import androidx.test.espresso.web.model.Atoms;
import androidx.test.espresso.web.model.Evaluation;
import androidx.test.espresso.web.model.TransformingAtom;
import androidx.test.internal.util.Checks;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class WebViewAssertions {
    private static final ResultDescriber<Object> TO_STRING_DESCRIBER = new ToStringResultDescriber();

    private WebViewAssertions() {
    }

    public static <E> WebAssertion<E> webMatches(Atom<E> atom, Matcher<E> resultMatcher, ResultDescriber<? super E> resultDescriber) {
        Checks.checkNotNull(resultMatcher);
        Checks.checkNotNull(resultDescriber);
        Checks.checkNotNull(atom);
        return new ResultCheckingWebAssertion<E>(atom, resultMatcher, resultDescriber);
    }

    public static <E> WebAssertion<E> webMatches(Atom<E> atom, Matcher<E> resultMatcher) {
        return WebViewAssertions.webMatches(atom, resultMatcher, TO_STRING_DESCRIBER);
    }

    public static WebAssertion<Document> webContent(Matcher<Document> domMatcher) {
        Checks.checkNotNull(domMatcher);
        return WebViewAssertions.webMatches(Atoms.transform(Atoms.script("function getHtml() {return document.documentElement.outerHTML;}"), new DocumentParserAtom()), domMatcher, new WebContentResultDescriber());
    }

    @VisibleForTesting
    static final class DocumentParserAtom
    implements TransformingAtom.Transformer<Evaluation, Document> {
        @RemoteMsgConstructor
        public DocumentParserAtom() {
        }

        @Override
        public Document apply(Evaluation eval) {
            if (eval.getValue() instanceof String) {
                try {
                    return TagSoupDocumentParser.newInstance().parse((String)eval.getValue());
                }
                catch (SAXException se) {
                    throw new RuntimeException("Parse failed: " + eval.getValue(), se);
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Parse failed: " + eval.getValue(), ioe);
                }
            }
            throw new RuntimeException("Value should have been a string: " + eval);
        }
    }

    @VisibleForTesting
    static final class WebContentResultDescriber
    implements ResultDescriber<Document> {
        @RemoteMsgConstructor
        public WebContentResultDescriber() {
        }

        @Override
        public String apply(Document document) {
            try {
                DOMSource docSource = new DOMSource(document);
                Transformer tf = TransformerFactory.newInstance().newTransformer();
                StringWriter writer = new StringWriter();
                StreamResult streamer = new StreamResult(writer);
                tf.transform(docSource, streamer);
                return writer.toString();
            }
            catch (TransformerException e) {
                return "Could not transform!!!" + e;
            }
        }
    }

    @VisibleForTesting
    static final class ToStringResultDescriber
    implements ResultDescriber<Object> {
        @RemoteMsgConstructor
        public ToStringResultDescriber() {
        }

        @Override
        public String apply(Object input) {
            return input.toString();
        }
    }

    @VisibleForTesting
    static final class ResultCheckingWebAssertion<E>
    extends WebAssertion<E> {
        @RemoteMsgField(order=0)
        private final Atom<E> atom;
        @RemoteMsgField(order=1)
        private final Matcher<E> resultMatcher;
        @RemoteMsgField(order=2)
        private final ResultDescriber<? super E> resultDescriber;

        @RemoteMsgConstructor
        ResultCheckingWebAssertion(Atom<E> atom, Matcher<E> resultMatcher, ResultDescriber<? super E> resultDescriber) {
            super(atom);
            this.atom = atom;
            this.resultMatcher = resultMatcher;
            this.resultDescriber = resultDescriber;
        }

        @Override
        protected void checkResult(WebView view, E result) {
            StringDescription description = new StringDescription();
            description.appendText("'");
            this.resultMatcher.describeTo((Description)description);
            description.appendText("' doesn't match: ");
            description.appendText(null == result ? "null" : this.resultDescriber.apply(result));
            ViewMatchers.assertThat((String)description.toString(), result, this.resultMatcher);
        }
    }

    public static interface ResultDescriber<E> {
        public String apply(E var1);
    }
}

