/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.bridge;

import androidx.concurrent.futures.ResolvableFuture;
import androidx.test.internal.util.Checks;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

public final class Conduit {
    private final String bridgeName;
    private final String errorMethod;
    private final String successMethod;
    private final String token;
    private final ResolvableFuture<String> jsResult;

    private Conduit(Builder builder) {
        this.bridgeName = (String)Checks.checkNotNull((Object)builder.bridgeName);
        this.errorMethod = (String)Checks.checkNotNull((Object)builder.errorMethod);
        this.successMethod = (String)Checks.checkNotNull((Object)builder.successMethod);
        this.token = (String)Checks.checkNotNull((Object)builder.token);
        this.jsResult = (ResolvableFuture)Checks.checkNotNull((Object)builder.jsResult);
    }

    public String wrapScriptInConduit(String script) {
        Checks.checkNotNull((Object)script);
        return this.wrapScriptInConduit(new StringBuilder(script)).toString();
    }

    public StringBuilder wrapScriptInConduit(StringBuilder script) {
        String preamble = "try{window." + this.bridgeName + "." + this.successMethod + "('" + this.token + "', ";
        script.insert(0, preamble).append(");").append("}catch(e){").append("window.").append(this.bridgeName).append(".").append(this.errorMethod).append("('").append(this.token).append("', 'error!');}");
        return script;
    }

    public ListenableFuture<String> getResult() {
        return this.jsResult;
    }

    ResolvableFuture<String> internalGetResult() {
        return this.jsResult;
    }

    String getToken() {
        return this.token;
    }

    static class Builder {
        private String bridgeName;
        private String errorMethod;
        private String successMethod;
        private String token;
        private ResolvableFuture<String> jsResult;

        Builder() {
        }

        @CanIgnoreReturnValue
        public Builder withBridgeName(String bridgeName) {
            this.bridgeName = (String)Checks.checkNotNull((Object)bridgeName);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withErrorMethod(String errorMethod) {
            this.errorMethod = (String)Checks.checkNotNull((Object)errorMethod);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withSuccessMethod(String successMethod) {
            this.successMethod = (String)Checks.checkNotNull((Object)successMethod);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withToken(String token) {
            this.token = (String)Checks.checkNotNull((Object)token);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withJsResult(ResolvableFuture<String> jsResult) {
            this.jsResult = (ResolvableFuture)Checks.checkNotNull(jsResult);
            return this;
        }

        public Conduit build() {
            return new Conduit(this);
        }
    }
}

