/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.bridge;

import android.util.Log;
import android.webkit.JavascriptInterface;
import androidx.test.espresso.web.bridge.Conduit;
import androidx.test.internal.util.Checks;
import java.util.ArrayList;
import java.util.List;

final class JavaScriptBoundBridge {
    private static final String TAG = "JS_BRIDGE";
    private final List<Conduit> conduits = new ArrayList<Conduit>();

    JavaScriptBoundBridge() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConduit(Conduit conduit) {
        Checks.checkNotNull((Object)conduit);
        List<Conduit> list = this.conduits;
        synchronized (list) {
            this.conduits.add(conduit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JavascriptInterface
    public void setResult(String token, String result) {
        Log.d((String)TAG, (String)("Token: " + token + " result: " + result));
        List<Conduit> list = this.conduits;
        synchronized (list) {
            for (int i = 0; i < this.conduits.size(); ++i) {
                Conduit conduit = this.conduits.get(i);
                if (!conduit.getToken().equals(token)) continue;
                conduit.internalGetResult().set((Object)result);
                this.conduits.remove(i);
                return;
            }
        }
        Log.e((String)TAG, (String)("UFO result received - token: " + token + " message: " + result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JavascriptInterface
    public void setError(String token, String error) {
        Log.d((String)TAG, (String)("Token: " + token + " result: " + error));
        List<Conduit> list = this.conduits;
        synchronized (list) {
            for (int i = 0; i < this.conduits.size(); ++i) {
                Conduit conduit = this.conduits.get(i);
                if (!conduit.getToken().equals(token)) continue;
                conduit.internalGetResult().setException((Throwable)new RuntimeException(error));
                this.conduits.remove(i);
                return;
            }
        }
        Log.e((String)TAG, (String)("UFO error received - token: " + token + " message: " + error));
    }

    @JavascriptInterface
    public void log_i(String tag, String message) {
        Log.i((String)tag, (String)message);
    }
}

