/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.bridge;

import androidx.concurrent.futures.ResolvableFuture;
import androidx.test.espresso.web.bridge.Conduit;
import androidx.test.espresso.web.bridge.JavaScriptBoundBridge;
import androidx.test.internal.util.Checks;
import java.util.concurrent.atomic.AtomicInteger;

public final class JavaScriptBridge {
    private static final AtomicInteger tokenGenerator = new AtomicInteger(0);
    static final String TAG = "JS_BRIDGE";
    static final String JS_BRIDGE_NAME = "__g_wd_jsb";
    private static volatile boolean initialized = false;
    private static JavaScriptBoundBridge boundBridge;

    public static Conduit makeConduit() {
        Checks.checkState((boolean)initialized, (Object)"Install bridge not called!");
        Checks.checkState((null != boundBridge ? 1 : 0) != 0, (Object)"Bridge not configured; chromium webviews do not need bridge");
        Conduit conduit = new Conduit.Builder().withBridgeName(JS_BRIDGE_NAME).withToken(String.valueOf(tokenGenerator.incrementAndGet())).withSuccessMethod("setResult").withErrorMethod("setError").withJsResult((ResolvableFuture<String>)ResolvableFuture.create()).build();
        boundBridge.addConduit(conduit);
        return conduit;
    }
}

