/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.matcher;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.web.matcher.AmbiguousElementMatcherException;
import androidx.test.internal.util.Checks;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class DomMatchers {
    private DomMatchers() {
    }

    public static Matcher<Document> containingTextInBody(String text) {
        Checks.checkNotNull((Object)text);
        return DomMatchers.withBody(DomMatchers.withTextContent((Matcher<String>)Matchers.containsString((String)text)));
    }

    public static Matcher<Document> withBody(Matcher<Element> bodyMatcher) {
        return new WithBodyMatcher(bodyMatcher);
    }

    public static Matcher<Document> hasElementWithId(String id) {
        return new HasElementWithIdMatcher(id);
    }

    public static Matcher<Document> elementById(String id, Matcher<Element> elementMatcher) {
        return new ElementByIdMatcher(id, elementMatcher);
    }

    public static Matcher<Document> hasElementWithXpath(String xpath) {
        return new HasElementWithXPathMatcher(xpath);
    }

    public static Matcher<Document> elementByXPath(String xpath, Matcher<Element> elementMatcher) {
        return new ElementByXPathMatcher(xpath, elementMatcher);
    }

    private static NodeList extractNodeListForXPath(String xpath, Document document) {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            XPathExpression expr = xPath.compile(xpath);
            return (NodeList)expr.evaluate(document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            return null;
        }
    }

    public static Matcher<Element> withTextContent(String textContent) {
        return DomMatchers.withTextContent((Matcher<String>)Matchers.is((Object)textContent));
    }

    public static Matcher<Element> withTextContent(Matcher<String> textContentMatcher) {
        return new WithTextContentMatcher(textContentMatcher);
    }

    @VisibleForTesting
    static final class WithTextContentMatcher
    extends TypeSafeMatcher<Element> {
        @RemoteMsgField(order=0)
        private final Matcher<String> textContentMatcher;

        @RemoteMsgConstructor
        WithTextContentMatcher(@NonNull Matcher<String> textContentMatcher) {
            this.textContentMatcher = (Matcher)Checks.checkNotNull(textContentMatcher, (Object)"textContentMatcher cannot be null");
        }

        protected boolean matchesSafely(Element element) {
            return this.textContentMatcher.matches((Object)element.getTextContent());
        }

        public void describeTo(Description description) {
            description.appendText("with text content: ");
            this.textContentMatcher.describeTo(description);
        }
    }

    @VisibleForTesting
    static final class ElementByXPathMatcher
    extends TypeSafeMatcher<Document> {
        @RemoteMsgField(order=0)
        private final String xpath;
        @RemoteMsgField(order=1)
        private final Matcher<Element> elementMatcher;

        @RemoteMsgConstructor
        ElementByXPathMatcher(String xpath, Matcher<Element> elementMatcher) {
            this.xpath = (String)Checks.checkNotNull((Object)xpath);
            this.elementMatcher = (Matcher)Checks.checkNotNull(elementMatcher);
        }

        public void describeTo(Description description) {
            description.appendText(String.format("element with xpath '%s' matches: ", this.xpath));
            this.elementMatcher.describeTo(description);
        }

        public boolean matchesSafely(Document document) {
            NodeList nodeList = DomMatchers.extractNodeListForXPath(this.xpath, document);
            if (nodeList == null || nodeList.getLength() == 0) {
                return false;
            }
            if (nodeList.getLength() > 1) {
                throw new AmbiguousElementMatcherException(this.xpath);
            }
            if (nodeList.item(0).getNodeType() != 1) {
                return false;
            }
            Element element = (Element)nodeList.item(0);
            return this.elementMatcher.matches((Object)element);
        }
    }

    @VisibleForTesting
    static final class HasElementWithXPathMatcher
    extends TypeSafeMatcher<Document> {
        @RemoteMsgField(order=0)
        private final String xpath;

        @RemoteMsgConstructor
        HasElementWithXPathMatcher(String xpath) {
            this.xpath = (String)Checks.checkNotNull((Object)xpath);
        }

        public void describeTo(Description description) {
            description.appendText("has element with xpath: " + this.xpath);
        }

        public boolean matchesSafely(Document document) {
            NodeList nodeList = DomMatchers.extractNodeListForXPath(this.xpath, document);
            return nodeList != null && nodeList.getLength() != 0;
        }
    }

    @VisibleForTesting
    static final class ElementByIdMatcher
    extends TypeSafeMatcher<Document> {
        @RemoteMsgField(order=0)
        private final String elementId;
        @RemoteMsgField(order=1)
        private final Matcher<Element> elementMatcher;

        @RemoteMsgConstructor
        ElementByIdMatcher(String elementId, Matcher<Element> elementMatcher) {
            this.elementId = (String)Checks.checkNotNull((Object)elementId);
            this.elementMatcher = (Matcher)Checks.checkNotNull(elementMatcher);
        }

        public void describeTo(Description description) {
            description.appendText(String.format("element with id '%s' matches: ", this.elementId));
            this.elementMatcher.describeTo(description);
        }

        public boolean matchesSafely(Document document) {
            return this.elementMatcher.matches((Object)document.getElementById(this.elementId));
        }
    }

    @VisibleForTesting
    static final class HasElementWithIdMatcher
    extends TypeSafeMatcher<Document> {
        @RemoteMsgField(order=0)
        private final String elementId;

        @RemoteMsgConstructor
        HasElementWithIdMatcher(String elementId) {
            this.elementId = (String)Checks.checkNotNull((Object)elementId);
        }

        public void describeTo(Description description) {
            description.appendText("has element with id: " + this.elementId);
        }

        public boolean matchesSafely(Document document) {
            return document.getElementById(this.elementId) != null;
        }
    }

    @VisibleForTesting
    static final class WithBodyMatcher
    extends TypeSafeMatcher<Document> {
        @RemoteMsgField(order=0)
        private final Matcher<Element> bodyMatcher;

        @RemoteMsgConstructor
        WithBodyMatcher(@NonNull Matcher<Element> bodyMatcher) {
            this.bodyMatcher = (Matcher)Checks.checkNotNull(bodyMatcher, (Object)"bodyMatcher cannot be null");
        }

        public void describeTo(Description description) {
            description.appendText("with body: ");
            this.bodyMatcher.describeTo(description);
        }

        public boolean matchesSafely(Document document) {
            NodeList nodeList = document.getElementsByTagName("body");
            if (nodeList.getLength() == 0) {
                return false;
            }
            return this.bodyMatcher.matches((Object)nodeList.item(0));
        }
    }
}

