/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.model;

import androidx.annotation.VisibleForTesting;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.web.model.Atom;
import androidx.test.espresso.web.model.Evaluation;
import androidx.test.espresso.web.model.SimpleAtom;
import androidx.test.espresso.web.model.TransformingAtom;
import androidx.test.internal.util.Checks;
import java.util.Collections;
import java.util.List;

public final class Atoms {
    private Atoms() {
    }

    public static <I, O> Atom<O> transform(Atom<I> in, TransformingAtom.Transformer<I, O> transformer) {
        return new TransformingAtom<I, O>(in, transformer);
    }

    public static <O> Atom<O> script(String script, TransformingAtom.Transformer<Evaluation, O> transformer) {
        return Atoms.transform(Atoms.script(script), transformer);
    }

    public static <E> TransformingAtom.Transformer<Evaluation, E> castOrDie(Class<E> clazz) {
        return new CastOrDieAtom((Class)Checks.checkNotNull(clazz));
    }

    public static Atom<Evaluation> script(String script) {
        return new ScriptWithArgsSimpleAtom(script, Collections.emptyList());
    }

    public static Atom<String> getCurrentUrl() {
        return Atoms.script("function getCurrentUrl() {return document.location.href;}", Atoms.castOrDie(String.class));
    }

    public static Atom<String> getTitle() {
        return Atoms.script("function getTitle() {return document.title;}", Atoms.castOrDie(String.class));
    }

    public static Atom<Evaluation> scriptWithArgs(String script, List<Object> args) {
        return new ScriptWithArgsSimpleAtom(script, args);
    }

    @VisibleForTesting
    static final class ScriptWithArgsSimpleAtom
    extends SimpleAtom {
        private final String script;
        private final List<Object> args;

        public ScriptWithArgsSimpleAtom(String script, List<Object> args) {
            super(script);
            this.script = (String)Checks.checkNotNull((Object)script);
            this.args = (List)Checks.checkNotNull(args);
        }

        @Override
        public List<Object> getNonContextualArguments() {
            return this.args;
        }
    }

    @VisibleForTesting
    static final class CastOrDieAtom<E>
    implements TransformingAtom.Transformer<Evaluation, E> {
        @RemoteMsgField(order=0)
        private final Class<E> clazz;

        @RemoteMsgConstructor
        private CastOrDieAtom(Class<E> clazz) {
            this.clazz = clazz;
        }

        @Override
        public E apply(Evaluation in) {
            if (null == in.getValue()) {
                throw new RuntimeException("Atom evaluation returned null!");
            }
            if (this.clazz.isInstance(in.getValue())) {
                return this.clazz.cast(in.getValue());
            }
            throw new RuntimeException(String.format("%s: is not compatible with Evaluation: %s", this.clazz.getName(), in.getValue().getClass().getName()));
        }
    }
}

