/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.model;

import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.web.model.JSONAble;
import androidx.test.internal.util.Checks;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONStringer;

public final class ElementReference
implements JSONAble {
    static final String KEY = "ELEMENT";
    @RemoteMsgField(order=0)
    final String opaque;
    static final JSONAble.DeJSONFactory DEJSONIZER = new JSONAble.DeJSONFactory(){

        @Override
        public Object attemptDeJSONize(Map<String, Object> map) {
            Object maybeOpaque;
            if (map.size() == 1 && (maybeOpaque = map.get(ElementReference.KEY)) instanceof String) {
                return new ElementReference((String)maybeOpaque);
            }
            return null;
        }
    };

    public int hashCode() {
        return this.opaque.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof ElementReference) {
            return ((ElementReference)other).opaque.equals(this.opaque);
        }
        return false;
    }

    public String toString() {
        return this.toJSONString();
    }

    @RemoteMsgConstructor
    ElementReference(String opaque) {
        this.opaque = (String)Checks.checkNotNull((Object)opaque);
    }

    String getOpaque() {
        return this.opaque;
    }

    @Override
    public String toJSONString() {
        try {
            return new JSONStringer().object().key(KEY).value((Object)this.opaque).endObject().toString();
        }
        catch (JSONException je) {
            throw new RuntimeException(je);
        }
    }
}

