/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.test.espresso.web.model.JSONAble;
import androidx.test.espresso.web.model.ModelCodec;
import androidx.test.internal.util.Checks;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONTokener;

public final class Evaluation
implements JSONAble,
Parcelable {
    private static final String STATUS_KEY = "status";
    private static final String MESSAGE_KEY = "message";
    private static final String VALUE_KEY = "value";
    private int status;
    private boolean hasMessage;
    private String message;
    private Object value;
    static final JSONAble.DeJSONFactory DEJSONIZER = new JSONAble.DeJSONFactory(){

        @Override
        public Object attemptDeJSONize(Map<String, Object> map) {
            Object maybeValue;
            Object maybeStatus;
            if (map.size() == 2 && (maybeStatus = map.get(Evaluation.STATUS_KEY)) instanceof Integer && null != (maybeValue = map.get(Evaluation.VALUE_KEY))) {
                Map mapValue;
                Builder builder = new Builder().setStatus((Integer)maybeStatus).setValue(maybeValue == JSONObject.NULL ? null : maybeValue);
                if (maybeValue instanceof Map && (mapValue = (Map)maybeValue).size() == 1) {
                    Object maybeMessage = mapValue.get(Evaluation.MESSAGE_KEY);
                    if (maybeMessage instanceof String) {
                        builder.setMessage((String)maybeMessage);
                    } else if (maybeMessage == JSONObject.NULL) {
                        builder.setMessage(null);
                    }
                }
                return builder.build();
            }
            return null;
        }
    };
    public static final Parcelable.Creator<Evaluation> CREATOR = new Parcelable.Creator<Evaluation>(){

        public Evaluation createFromParcel(Parcel in) {
            return new Evaluation(in);
        }

        public Evaluation[] newArray(int size) {
            return new Evaluation[size];
        }
    };

    private Evaluation(Builder b) {
        this.status = b.status;
        this.value = b.value;
        this.hasMessage = b.hasMessage;
        this.message = b.message;
    }

    protected Evaluation(Parcel in) {
        this.readFromParcel(in);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.value, this.hasMessage, this.message);
    }

    public boolean equals(Object o) {
        if (o instanceof Evaluation) {
            Evaluation other = (Evaluation)o;
            if (other.status == this.status && this.hasMessage == other.hasMessage) {
                if (this.hasMessage) {
                    return this.message.equals(other.message);
                }
                if (this.value == null) {
                    return other.value == null;
                }
                return this.value.equals(other.value);
            }
        }
        return false;
    }

    public int getStatus() {
        return this.status;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    public boolean hasMessage() {
        return this.hasMessage;
    }

    public String getMessage() {
        Checks.checkState((boolean)this.hasMessage);
        return this.message;
    }

    @Override
    public String toJSONString() {
        try {
            JSONStringer stringer = new JSONStringer().object().key(STATUS_KEY).value((long)this.status).key(VALUE_KEY);
            if (this.value instanceof String || this.value instanceof Number || this.value instanceof Boolean || this.value == null) {
                stringer.value(this.value);
            } else {
                String jsonValue = ModelCodec.encode(this.value);
                stringer.value(new JSONTokener(jsonValue).nextValue());
            }
            stringer.endObject();
            return stringer.toString();
        }
        catch (JSONException je) {
            throw new RuntimeException(je);
        }
    }

    public String toString() {
        return String.format(Locale.US, "Evaluation: status: %d value: %s hasMessage: %s message: %s", this.status, this.value, this.hasMessage, this.message);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(ModelCodec.encode(this));
    }

    public void readFromParcel(Parcel in) {
        Evaluation evaluation = ModelCodec.decodeEvaluation(in.readString());
        this.status = evaluation.status;
        this.hasMessage = evaluation.hasMessage;
        this.message = evaluation.message;
        this.value = evaluation.value;
    }

    static class Builder {
        private Object value;
        private int status;
        private boolean hasMessage;
        private String message;

        Builder() {
        }

        public Builder setMessage(String message) {
            this.message = message;
            this.hasMessage = true;
            return this;
        }

        public Builder setValue(Object value) {
            this.value = value;
            return this;
        }

        public Builder setStatus(int status) {
            this.status = status;
            return this;
        }

        public Evaluation build() {
            return new Evaluation(this);
        }
    }
}

