/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.model;

import android.util.JsonReader;
import android.util.Log;
import androidx.test.espresso.web.model.ElementReference;
import androidx.test.espresso.web.model.Evaluation;
import androidx.test.espresso.web.model.JSONAble;
import androidx.test.espresso.web.model.WindowReference;
import androidx.test.internal.util.Checks;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;

public final class ModelCodec {
    private static final String TAG = "JS_CODEC";
    private static final Set<Class<?>> VALUEABLE_CLASSES = Collections.unmodifiableSet(new LinkedHashSet<Class>(Arrays.asList(Boolean.class, Number.class, String.class, JSONObject.class, JSONArray.class)));
    private static final Set<Class<?>> TOP_LEVEL_CLASSES = Collections.unmodifiableSet(new LinkedHashSet<Class>(Arrays.asList(JSONObject.class, JSONArray.class, Iterable.class, Object[].class, Map.class, JSONAble.class)));
    private static final CopyOnWriteArrayList<JSONAble.DeJSONFactory> DEJSONIZERS = new CopyOnWriteArrayList<JSONAble.DeJSONFactory>(Arrays.asList(Evaluation.DEJSONIZER, WindowReference.DEJSONIZER, ElementReference.DEJSONIZER));

    private ModelCodec() {
    }

    public static Evaluation decodeEvaluation(String json) {
        Object obj = ModelCodec.decode(json);
        if (obj instanceof Evaluation) {
            return (Evaluation)obj;
        }
        throw new IllegalArgumentException(String.format("Document: \"%s\" did not decode to an evaluation. Instead: \"%s\"", json, obj));
    }

    public static String encode(Object javaObject) {
        Checks.checkNotNull((Object)javaObject);
        try {
            if (javaObject instanceof JSONObject) {
                return javaObject.toString();
            }
            if (javaObject instanceof JSONArray) {
                return javaObject.toString();
            }
            if (javaObject instanceof JSONAble) {
                return new JSONObject(((JSONAble)javaObject).toJSONString()).toString();
            }
            if (javaObject instanceof Iterable || javaObject instanceof Map || javaObject instanceof Object[]) {
                JSONStringer stringer = new JSONStringer();
                return ModelCodec.encodeHelper(javaObject, stringer).toString();
            }
            throw new IllegalArgumentException(String.format("%s: not a valid top level class. Want one of: %s", javaObject.getClass(), TOP_LEVEL_CLASSES));
        }
        catch (JSONException je) {
            throw new RuntimeException("Encode failed: " + javaObject, je);
        }
    }

    public static void removeDeJSONFactory(JSONAble.DeJSONFactory dejson) {
        DEJSONIZERS.remove(dejson);
    }

    public static void addDeJSONFactory(JSONAble.DeJSONFactory dejson) {
        DEJSONIZERS.add((JSONAble.DeJSONFactory)Checks.checkNotNull((Object)dejson));
    }

    static Object decode(String json) {
        Checks.checkNotNull((Object)json);
        Checks.checkArgument((!"".equals(json) ? 1 : 0) != 0, (Object)"Empty docs not supported.");
        try {
            return ModelCodec.decodeViaJSONReader(json);
        }
        catch (IOException ioe) {
            throw new RuntimeException(String.format("Could not parse: %s", json), ioe);
        }
    }

    private static List<Object> decodeArray(JSONArray array) throws JSONException {
        ArrayList<Object> data = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            if (array.isNull(i)) {
                data.add(null);
                continue;
            }
            Object value = array.get(i);
            if (value instanceof JSONObject) {
                data.add(ModelCodec.decodeObject((JSONObject)value));
                continue;
            }
            if (value instanceof JSONArray) {
                data.add(ModelCodec.decodeArray((JSONArray)value));
                continue;
            }
            data.add(value);
        }
        return data;
    }

    private static Object decodeObject(JSONObject jsonObject) throws JSONException {
        ArrayList<String> nullKeys = new ArrayList<String>();
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (jsonObject.isNull(key)) {
                nullKeys.add(key);
                obj.put(key, JSONObject.NULL);
                continue;
            }
            Object value = jsonObject.get(key);
            if (value instanceof JSONObject) {
                obj.put(key, ModelCodec.decodeObject((JSONObject)value));
                continue;
            }
            if (value instanceof JSONArray) {
                obj.put(key, ModelCodec.decodeArray((JSONArray)value));
                continue;
            }
            obj.put(key, value);
        }
        Object replacement = ModelCodec.maybeReplaceMap(obj);
        if (replacement != null) {
            return replacement;
        }
        for (String key : nullKeys) {
            obj.remove(key);
        }
        return obj;
    }

    private static Object decodeViaJSONReader(String json) throws IOException {
        JsonReader reader = null;
        try {
            reader = new JsonReader((Reader)new StringReader(json));
            switch (reader.peek()) {
                case BEGIN_OBJECT: {
                    Object object = ModelCodec.decodeObject(reader);
                    return object;
                }
                case BEGIN_ARRAY: {
                    List<Object> list = ModelCodec.decodeArray(reader);
                    return list;
                }
            }
            throw new IllegalStateException("Bogus document: " + json);
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    Log.i((String)TAG, (String)"json reader - close exception", (Throwable)ioe);
                }
            }
        }
    }

    private static List<Object> decodeArray(JsonReader reader) throws IOException {
        ArrayList<Object> array = new ArrayList<Object>();
        reader.beginArray();
        block8: while (reader.hasNext()) {
            switch (reader.peek()) {
                case BEGIN_OBJECT: {
                    array.add(ModelCodec.decodeObject(reader));
                    continue block8;
                }
                case NULL: {
                    reader.nextNull();
                    array.add(null);
                    continue block8;
                }
                case STRING: {
                    array.add(reader.nextString());
                    continue block8;
                }
                case BOOLEAN: {
                    array.add(reader.nextBoolean());
                    continue block8;
                }
                case BEGIN_ARRAY: {
                    array.add(ModelCodec.decodeArray(reader));
                    continue block8;
                }
                case NUMBER: {
                    array.add(ModelCodec.decodeNumber(reader.nextString()));
                    continue block8;
                }
            }
            throw new IllegalStateException(String.format("%s: bogus token", reader.peek()));
        }
        reader.endArray();
        return array;
    }

    private static Number decodeNumber(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException i) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException i2) {
                try {
                    return Double.valueOf(value);
                }
                catch (NumberFormatException i3) {
                    try {
                        return new BigInteger(value);
                    }
                    catch (NumberFormatException i4) {
                        return new BigDecimal(value);
                    }
                }
            }
        }
    }

    private static Object decodeObject(JsonReader reader) throws IOException {
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        ArrayList<String> nullKeys = new ArrayList<String>();
        reader.beginObject();
        block8: while (reader.hasNext()) {
            String key = reader.nextName();
            Object value = null;
            switch (reader.peek()) {
                case BEGIN_OBJECT: {
                    obj.put(key, ModelCodec.decodeObject(reader));
                    continue block8;
                }
                case NULL: {
                    reader.nextNull();
                    nullKeys.add(key);
                    obj.put(key, JSONObject.NULL);
                    continue block8;
                }
                case STRING: {
                    obj.put(key, reader.nextString());
                    continue block8;
                }
                case BOOLEAN: {
                    obj.put(key, reader.nextBoolean());
                    continue block8;
                }
                case NUMBER: {
                    obj.put(key, ModelCodec.decodeNumber(reader.nextString()));
                    continue block8;
                }
                case BEGIN_ARRAY: {
                    obj.put(key, ModelCodec.decodeArray(reader));
                    continue block8;
                }
            }
            throw new IllegalStateException(String.format("%s: bogus token.", reader.peek()));
        }
        reader.endObject();
        Object replacement = ModelCodec.maybeReplaceMap(obj);
        if (null != replacement) {
            return replacement;
        }
        for (String key : nullKeys) {
            obj.remove(key);
        }
        return obj;
    }

    private static Object maybeReplaceMap(Map<String, Object> obj) {
        for (JSONAble.DeJSONFactory dejsonizer : DEJSONIZERS) {
            Object maybe = dejsonizer.attemptDeJSONize(obj);
            if (null == maybe) continue;
            return maybe;
        }
        return null;
    }

    private static JSONStringer encodeHelper(Object javaObject, JSONStringer stringer) throws JSONException {
        if (null == javaObject) {
            stringer.value(javaObject);
        } else if (javaObject instanceof Map) {
            stringer.object();
            Set entries = ((Map)javaObject).entrySet();
            for (Map.Entry entry : entries) {
                stringer.key(entry.getKey().toString());
                ModelCodec.encodeHelper(entry.getValue(), stringer);
            }
            stringer.endObject();
        } else if (javaObject instanceof Iterable) {
            stringer.array();
            for (Object obj : (Iterable)javaObject) {
                ModelCodec.encodeHelper(obj, stringer);
            }
            stringer.endArray();
        } else if (javaObject instanceof Object[]) {
            stringer.array();
            for (Object obj : (Object[])javaObject) {
                ModelCodec.encodeHelper(obj, stringer);
            }
            stringer.endArray();
        } else if (javaObject instanceof JSONAble) {
            JSONObject jsonObj = new JSONObject(((JSONAble)javaObject).toJSONString());
            stringer.value((Object)jsonObj);
        } else {
            boolean converted = false;
            for (Class<?> valuableClazz : VALUEABLE_CLASSES) {
                if (!valuableClazz.isAssignableFrom(javaObject.getClass())) continue;
                converted = true;
                stringer.value(javaObject);
            }
            Checks.checkState((boolean)converted, (String)"%s: not encodable. Want one of: %s", (Object[])new Object[]{javaObject.getClass(), VALUEABLE_CLASSES});
        }
        return stringer;
    }
}

