/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.model;

import androidx.annotation.Nullable;
import androidx.test.espresso.web.model.Atom;
import androidx.test.espresso.web.model.ElementReference;
import androidx.test.espresso.web.model.Evaluation;
import androidx.test.internal.util.Checks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SimpleAtom
implements Atom<Evaluation> {
    private final String script;
    private final ElementReferencePlacement elementPlacement;

    public SimpleAtom(String script) {
        this(script, ElementReferencePlacement.FIRST);
    }

    public SimpleAtom(String script, ElementReferencePlacement elementPlacement) {
        this.script = (String)Checks.checkNotNull((Object)script);
        this.elementPlacement = (ElementReferencePlacement)((Object)Checks.checkNotNull((Object)((Object)elementPlacement)));
    }

    @Override
    public final String getScript() {
        return this.script;
    }

    @Override
    public final Evaluation transform(Evaluation e) {
        if (e.getStatus() != 0) {
            return (Evaluation)Checks.checkNotNull((Object)this.handleBadEvaluation(e), (Object)("Evaluation bad and handler returned null! " + e));
        }
        return e;
    }

    @Override
    public final List<Object> getArguments(@Nullable ElementReference elementRef) {
        List nonContextualArguments = (List)Checks.checkNotNull(this.getNonContextualArguments());
        if (null == elementRef) {
            this.handleNoElementReference();
        }
        if (nonContextualArguments.size() == 0 && null == elementRef) {
            return Collections.EMPTY_LIST;
        }
        if (null == elementRef) {
            return nonContextualArguments;
        }
        ArrayList<Object> args = new ArrayList<Object>(nonContextualArguments.size() + 1);
        if (this.elementPlacement == ElementReferencePlacement.FIRST) {
            args.add(elementRef);
            args.addAll(nonContextualArguments);
        } else {
            args.addAll(nonContextualArguments);
            args.add(elementRef);
        }
        return args;
    }

    protected void handleNoElementReference() {
    }

    protected List<Object> getNonContextualArguments() {
        return Collections.EMPTY_LIST;
    }

    protected Evaluation handleBadEvaluation(Evaluation e) {
        throw new RuntimeException("Error in evaluation" + e);
    }

    public static enum ElementReferencePlacement {
        FIRST,
        LAST;

    }
}

