/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.sugar;

import android.view.View;
import androidx.annotation.CheckResult;
import androidx.annotation.Nullable;
import androidx.test.espresso.Espresso;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.web.action.AtomAction;
import androidx.test.espresso.web.action.EnableJavascriptAction;
import androidx.test.espresso.web.assertion.WebAssertion;
import androidx.test.espresso.web.model.Atom;
import androidx.test.espresso.web.model.ElementReference;
import androidx.test.espresso.web.model.WindowReference;
import androidx.test.internal.platform.util.TestOutputEmitter;
import androidx.test.internal.util.Checks;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.CheckReturnValue;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class Web {
    public static WebInteraction<Void> onWebView() {
        return Web.onWebView((Matcher<View>)ViewMatchers.isJavascriptEnabled());
    }

    public static WebInteraction<Void> onWebView(Matcher<View> viewMatcher) {
        return new WebInteraction<Void>(viewMatcher);
    }

    static {
        HashMap<String, String> usageProperties = new HashMap<String, String>();
        usageProperties.put("Espresso-Web", "1");
        TestOutputEmitter.addOutputProperties(usageProperties);
    }

    public static class WebInteraction<R> {
        private final Matcher<View> viewMatcher;
        private final boolean brandNew;
        @Nullable
        private final R result;
        @Nullable
        private final WindowReference window;
        @Nullable
        private final ElementReference element;
        private final Timeout timeout;

        private WebInteraction(Matcher<View> viewMatcher) {
            this(viewMatcher, null, null, null, true, new Timeout(10L, TimeUnit.SECONDS, true));
        }

        private WebInteraction(Matcher<View> viewMatcher, R result, WindowReference window, ElementReference element, boolean brandNew, Timeout timeout) {
            this.viewMatcher = (Matcher)Checks.checkNotNull(viewMatcher);
            this.result = result;
            this.window = window;
            this.element = element;
            this.brandNew = brandNew;
            this.timeout = timeout;
        }

        public WebInteraction<R> reset() {
            return new WebInteraction<R>(this.viewMatcher, this.result, null, null, this.brandNew, this.timeout);
        }

        public WebInteraction<R> forceJavascriptEnabled() {
            Espresso.onView(this.viewMatcher).perform(new ViewAction[]{new EnableJavascriptAction()});
            return this;
        }

        @CheckReturnValue
        @CheckResult
        public WebInteraction<R> withNoTimeout() {
            return new WebInteraction<R>(this.viewMatcher, this.result, this.window, this.element, this.brandNew, Timeout.NONE);
        }

        @CheckReturnValue
        @CheckResult
        public WebInteraction<R> withTimeout(long amount, TimeUnit unit) {
            return new WebInteraction<R>(this.viewMatcher, this.result, this.window, this.element, this.brandNew, new Timeout(amount, unit, true));
        }

        @CheckReturnValue
        @CheckResult
        public WebInteraction<R> inWindow(WindowReference window) {
            return new WebInteraction<R>(this.viewMatcher, this.result, window, this.element, this.brandNew, this.timeout);
        }

        @CheckReturnValue
        @CheckResult
        public WebInteraction<R> inWindow(Atom<WindowReference> windowPicker) {
            return new WebInteraction<R>(this.viewMatcher, this.result, this.doEval(windowPicker, null, null), this.element, this.brandNew, this.timeout);
        }

        @CheckReturnValue
        @CheckResult
        public WebInteraction<R> withElement(ElementReference element) {
            return new WebInteraction<R>(this.viewMatcher, this.result, this.window, element, this.brandNew, this.timeout);
        }

        @CheckReturnValue
        @CheckResult
        public WebInteraction<R> withElement(Atom<ElementReference> elementPicker) {
            return new WebInteraction<R>(this.viewMatcher, this.result, this.window, this.doEval(elementPicker, this.window, null), this.brandNew, this.timeout);
        }

        @CheckReturnValue
        @CheckResult
        public WebInteraction<R> withContextualElement(Atom<ElementReference> elementPicker) {
            return new WebInteraction<R>(this.viewMatcher, this.result, this.window, this.doEval(elementPicker, this.window, this.element), this.brandNew, this.timeout);
        }

        public <E> WebInteraction<E> perform(Atom<E> atom) {
            E newResult = this.doEval(atom, this.window, this.element);
            return new WebInteraction<E>(this.viewMatcher, newResult, this.window, this.element, false, this.timeout);
        }

        public <E> WebInteraction<E> check(WebAssertion<E> assertion) {
            E newResult = this.doEval(assertion.getAtom(), this.window, this.element);
            Espresso.onView(this.viewMatcher).check(assertion.toViewAssertion(newResult));
            return new WebInteraction<E>(this.viewMatcher, newResult, this.window, this.element, false, this.timeout);
        }

        private <E> E doEval(Atom<E> atom, WindowReference window, ElementReference elem) {
            Checks.checkNotNull(atom, (Object)"Need an atom!");
            AtomAction<E> atomAction = new AtomAction<E>(atom, window, elem);
            Espresso.onView(this.viewMatcher).perform(new ViewAction[]{atomAction});
            try {
                if (this.timeout == Timeout.NONE) {
                    return atomAction.get();
                }
                return atomAction.get(this.timeout.timeout, this.timeout.unit);
            }
            catch (ExecutionException ee) {
                Espresso.onView(this.viewMatcher).perform(new ViewAction[]{new ExceptionPropagator(ee.getCause())});
                return null;
            }
            catch (InterruptedException ie) {
                Espresso.onView(this.viewMatcher).perform(new ViewAction[]{new ExceptionPropagator(ie)});
                return null;
            }
            catch (TimeoutException te) {
                Espresso.onView(this.viewMatcher).perform(new ViewAction[]{new ExceptionPropagator(te)});
                return null;
            }
            catch (RuntimeException re) {
                Espresso.onView(this.viewMatcher).perform(new ViewAction[]{new ExceptionPropagator(re)});
                return null;
            }
        }

        public R get() {
            Checks.checkState((!this.brandNew ? 1 : 0) != 0, (Object)"Perform or Check never called on this WebInteraction!");
            return this.result;
        }

        static class ExceptionPropagator
        implements ViewAction {
            @RemoteMsgField(order=0)
            private final RuntimeException error;

            @RemoteMsgConstructor
            public ExceptionPropagator(RuntimeException error) {
                this.error = (RuntimeException)Checks.checkNotNull((Object)error);
            }

            public ExceptionPropagator(Throwable t) {
                this(new RuntimeException(t));
            }

            public String getDescription() {
                return "Propagate: " + this.error;
            }

            public void perform(UiController uiController, View view) {
                throw this.error;
            }

            public Matcher<View> getConstraints() {
                return Matchers.any(View.class);
            }
        }
    }

    private static class Timeout {
        private final long timeout;
        private final TimeUnit unit;
        static final Timeout NONE = new Timeout(-1L, TimeUnit.MILLISECONDS, false);

        private Timeout(long timeout, TimeUnit unit, boolean check) {
            this.timeout = timeout;
            this.unit = unit;
            if (check) {
                Checks.checkArgument((timeout > 0L ? 1 : 0) != 0);
                Checks.checkNotNull((Object)((Object)unit));
            }
        }
    }
}

