/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.util.concurrent;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.test.espresso.web.util.concurrent.AsyncFunction;
import androidx.test.espresso.web.util.concurrent.FutureChain;
import androidx.test.espresso.web.util.concurrent.Futures;
import androidx.test.internal.util.Checks;
import androidx.test.platform.concurrent.DirectExecutor;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class ChainingListenableFuture<I, O>
extends FutureChain<O>
implements Runnable {
    @Nullable
    private AsyncFunction<? super I, ? extends O> function;
    private final BlockingQueue<Boolean> mayInterruptIfRunningChannel = new LinkedBlockingQueue<Boolean>(1);
    private final CountDownLatch outputCreated = new CountDownLatch(1);
    @Nullable
    private ListenableFuture<? extends I> inputFuture;
    @Nullable
    volatile ListenableFuture<? extends O> outputFuture;

    ChainingListenableFuture(@NonNull AsyncFunction<? super I, ? extends O> function, @NonNull ListenableFuture<? extends I> inputFuture) {
        this.function = (AsyncFunction)Checks.checkNotNull(function);
        this.inputFuture = (ListenableFuture)Checks.checkNotNull(inputFuture);
    }

    @Override
    @Nullable
    public O get() throws InterruptedException, ExecutionException {
        if (!this.isDone()) {
            ListenableFuture<? extends I> inputFuture = this.inputFuture;
            if (inputFuture != null) {
                inputFuture.get();
            }
            this.outputCreated.await();
            ListenableFuture<? extends O> outputFuture = this.outputFuture;
            if (outputFuture != null) {
                outputFuture.get();
            }
        }
        return (O)super.get();
    }

    @Override
    @Nullable
    public O get(long timeout, @NonNull TimeUnit unit) throws TimeoutException, ExecutionException, InterruptedException {
        if (!this.isDone()) {
            long start;
            ListenableFuture<? extends I> inputFuture;
            if (unit != TimeUnit.NANOSECONDS) {
                timeout = TimeUnit.NANOSECONDS.convert(timeout, unit);
                unit = TimeUnit.NANOSECONDS;
            }
            if ((inputFuture = this.inputFuture) != null) {
                start = System.nanoTime();
                inputFuture.get(timeout, unit);
                timeout -= Math.max(0L, System.nanoTime() - start);
            }
            start = System.nanoTime();
            if (!this.outputCreated.await(timeout, unit)) {
                throw new TimeoutException();
            }
            timeout -= Math.max(0L, System.nanoTime() - start);
            ListenableFuture<? extends O> outputFuture = this.outputFuture;
            if (outputFuture != null) {
                outputFuture.get(timeout, unit);
            }
        }
        return (O)super.get(timeout, unit);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (super.cancel(mayInterruptIfRunning)) {
            this.putUninterruptibly(this.mayInterruptIfRunningChannel, mayInterruptIfRunning);
            this.cancel((Future<?>)this.inputFuture, mayInterruptIfRunning);
            this.cancel((Future<?>)this.outputFuture, mayInterruptIfRunning);
            return true;
        }
        return false;
    }

    private void cancel(@Nullable Future<?> future, boolean mayInterruptIfRunning) {
        if (future != null) {
            future.cancel(mayInterruptIfRunning);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        block16: {
            try {
                I sourceResult;
                try {
                    sourceResult = Futures.getUninterruptibly(this.inputFuture);
                }
                catch (CancellationException e) {
                    this.cancel(false);
                    this.function = null;
                    this.inputFuture = null;
                    this.outputCreated.countDown();
                    return;
                }
                catch (ExecutionException e) {
                    this.setException(e.getCause());
                    this.function = null;
                    this.inputFuture = null;
                    this.outputCreated.countDown();
                    return;
                }
                this.outputFuture = this.function.apply(sourceResult);
                final ListenableFuture<? extends O> outputFuture = this.outputFuture;
                if (this.isCancelled()) {
                    outputFuture.cancel(this.takeUninterruptibly(this.mayInterruptIfRunningChannel).booleanValue());
                    this.outputFuture = null;
                    return;
                }
                outputFuture.addListener(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ChainingListenableFuture.this.set(Futures.getUninterruptibly(outputFuture));
                        }
                        catch (CancellationException e) {
                            ChainingListenableFuture.this.cancel(false);
                            return;
                        }
                        catch (ExecutionException e) {
                            ChainingListenableFuture.this.setException(e.getCause());
                        }
                        finally {
                            ChainingListenableFuture.this.outputFuture = null;
                        }
                    }
                }, (Executor)DirectExecutor.INSTANCE);
                break block16;
                {
                    catch (UndeclaredThrowableException e) {
                        this.setException(e.getCause());
                        break block16;
                    }
                    catch (Exception e) {
                        this.setException(e);
                        break block16;
                    }
                    catch (Error e) {
                        this.setException(e);
                        break block16;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.function = null;
                this.inputFuture = null;
                this.outputCreated.countDown();
            }
        }
    }

    private <E> E takeUninterruptibly(@NonNull BlockingQueue<E> queue) {
        boolean interrupted = false;
        while (true) {
            try {
                E e = queue.take();
                return e;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private <E> void putUninterruptibly(@NonNull BlockingQueue<E> queue, @NonNull E element) {
        boolean interrupted = false;
        while (true) {
            try {
                queue.put(element);
                return;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

