/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.util.concurrent;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.test.espresso.web.util.concurrent.AsyncFunction;
import androidx.test.espresso.web.util.concurrent.FutureCallback;
import androidx.test.espresso.web.util.concurrent.Futures;
import androidx.test.internal.util.Checks;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.jvm.functions.Function1;

class FutureChain<V>
implements ListenableFuture<V> {
    @NonNull
    private final ListenableFuture<V> mDelegate;
    @Nullable
    CallbackToFutureAdapter.Completer<V> mCompleter;

    @NonNull
    public static <V> FutureChain<V> from(@NonNull ListenableFuture<V> future) {
        return future instanceof FutureChain ? (FutureChain<V>)future : new FutureChain<V>(future);
    }

    @NonNull
    public final <T> FutureChain<T> transformAsync(@NonNull AsyncFunction<? super V, T> function, @NonNull Executor executor) {
        return (FutureChain)Futures.transformAsync(this, function, executor);
    }

    @NonNull
    public final <T> FutureChain<T> transform(@NonNull Function1<? super V, T> function, @NonNull Executor executor) {
        return (FutureChain)Futures.transform(this, function, executor);
    }

    public final void addCallback(@NonNull FutureCallback<? super V> callback, @NonNull Executor executor) {
        Futures.addCallback(this, callback, executor);
    }

    FutureChain(@NonNull ListenableFuture<V> delegate) {
        this.mDelegate = (ListenableFuture)Checks.checkNotNull(delegate);
    }

    FutureChain() {
        this.mDelegate = CallbackToFutureAdapter.getFuture((CallbackToFutureAdapter.Resolver)new CallbackToFutureAdapter.Resolver<V>(){

            public Object attachCompleter(@NonNull CallbackToFutureAdapter.Completer<V> completer) {
                Checks.checkState((FutureChain.this.mCompleter == null ? 1 : 0) != 0, (Object)"The result can only set once!");
                FutureChain.this.mCompleter = completer;
                return "FutureChain[" + FutureChain.this + "]";
            }
        });
    }

    public void addListener(@NonNull Runnable listener, @NonNull Executor executor) {
        this.mDelegate.addListener(listener, executor);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.mDelegate.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.mDelegate.isCancelled();
    }

    public boolean isDone() {
        return this.mDelegate.isDone();
    }

    @Nullable
    public V get() throws InterruptedException, ExecutionException {
        return (V)this.mDelegate.get();
    }

    @Nullable
    public V get(long timeout, @NonNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (V)this.mDelegate.get(timeout, unit);
    }

    boolean set(@Nullable V value) {
        if (this.mCompleter != null) {
            return this.mCompleter.set(value);
        }
        return false;
    }

    boolean setException(@NonNull Throwable throwable) {
        if (this.mCompleter != null) {
            return this.mCompleter.setException(throwable);
        }
        return false;
    }
}

