/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.util.concurrent;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.test.espresso.web.util.concurrent.AsyncFunction;
import androidx.test.espresso.web.util.concurrent.ChainingListenableFuture;
import androidx.test.espresso.web.util.concurrent.FutureCallback;
import androidx.test.espresso.web.util.concurrent.ImmediateFuture;
import androidx.test.internal.util.Checks;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import kotlin.jvm.functions.Function1;

public final class Futures {
    @NonNull
    public static <V> ListenableFuture<V> immediateFuture(@Nullable V value) {
        if (value == null) {
            return ImmediateFuture.nullFuture();
        }
        return new ImmediateFuture.ImmediateSuccessfulFuture<V>(value);
    }

    @NonNull
    public static <V> ListenableFuture<V> immediateFailedFuture(@NonNull Throwable cause) {
        return new ImmediateFuture.ImmediateFailedFuture(cause);
    }

    @NonNull
    public static <I, O> ListenableFuture<O> transformAsync(@NonNull ListenableFuture<I> input, @NonNull AsyncFunction<? super I, ? extends O> function, @NonNull Executor executor) {
        ChainingListenableFuture<? super I, ? extends O> output = new ChainingListenableFuture<I, O>(function, input);
        input.addListener(output, executor);
        return output;
    }

    @NonNull
    public static <I, O> ListenableFuture<O> transform(@NonNull ListenableFuture<I> input, final @NonNull Function1<? super I, ? extends O> function, @NonNull Executor executor) {
        Checks.checkNotNull(function);
        return Futures.transformAsync(input, new AsyncFunction<I, O>(){

            @Override
            @NonNull
            public ListenableFuture<O> apply(I input) {
                return Futures.immediateFuture(function.invoke(input));
            }
        }, executor);
    }

    public static <V> void addCallback(@NonNull ListenableFuture<V> future, @NonNull FutureCallback<? super V> callback, @NonNull Executor executor) {
        Checks.checkNotNull(callback);
        future.addListener(new CallbackListener<V>(future, callback), executor);
    }

    @Nullable
    public static <V> V getDone(@NonNull Future<V> future) throws ExecutionException {
        Checks.checkState((boolean)future.isDone(), (Object)("Future was expected to be done, " + future));
        return Futures.getUninterruptibly(future);
    }

    @Nullable
    public static <V> V getUninterruptibly(@NonNull Future<V> future) throws ExecutionException {
        boolean interrupted = false;
        while (true) {
            try {
                V v = future.get();
                return v;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private Futures() {
    }

    private static final class CallbackListener<V>
    implements Runnable {
        final Future<V> mFuture;
        final FutureCallback<? super V> mCallback;

        CallbackListener(Future<V> future, FutureCallback<? super V> callback) {
            this.mFuture = future;
            this.mCallback = callback;
        }

        @Override
        public void run() {
            V value;
            try {
                value = Futures.getDone(this.mFuture);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause == null) {
                    this.mCallback.onFailure(e);
                } else {
                    this.mCallback.onFailure(cause);
                }
                return;
            }
            catch (Error | RuntimeException e) {
                this.mCallback.onFailure(e);
                return;
            }
            this.mCallback.onSuccess(value);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "," + this.mCallback;
        }
    }
}

