/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.util.concurrent;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.test.internal.util.Checks;
import androidx.test.platform.concurrent.DirectExecutor;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

class ListFuture<V>
implements ListenableFuture<List<V>> {
    @Nullable
    List<? extends ListenableFuture<? extends V>> futures;
    @Nullable
    List<V> values;
    private final boolean allMustSucceed;
    @NonNull
    private final AtomicInteger remaining;
    @NonNull
    private final ListenableFuture<List<V>> result;
    CallbackToFutureAdapter.Completer<List<V>> resultNotifier;

    ListFuture(@NonNull List<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed, @NonNull Executor listenerExecutor) {
        this.futures = (List)Checks.checkNotNull(futures);
        this.values = new ArrayList<V>(futures.size());
        this.allMustSucceed = allMustSucceed;
        this.remaining = new AtomicInteger(futures.size());
        this.result = CallbackToFutureAdapter.getFuture((CallbackToFutureAdapter.Resolver)new CallbackToFutureAdapter.Resolver<List<V>>(){

            public Object attachCompleter(@NonNull CallbackToFutureAdapter.Completer<List<V>> completer) {
                Checks.checkState((ListFuture.this.resultNotifier == null ? 1 : 0) != 0, (Object)"The result can only set once!");
                ListFuture.this.resultNotifier = completer;
                return "ListFuture[" + this + "]";
            }
        });
        this.init(listenerExecutor);
    }

    private void init(@NonNull Executor listenerExecutor) {
        this.addListener(new Runnable(){

            @Override
            public void run() {
                ListFuture.this.values = null;
                ListFuture.this.futures = null;
            }
        }, (Executor)DirectExecutor.INSTANCE);
        if (this.futures.isEmpty()) {
            this.resultNotifier.set(new ArrayList<V>(this.values));
            return;
        }
        for (int i = 0; i < this.futures.size(); ++i) {
            this.values.add(null);
        }
        List<ListenableFuture<V>> localFutures = this.futures;
        int i = 0;
        while (i < localFutures.size()) {
            final ListenableFuture<? extends V> listenable = localFutures.get(i);
            final int index = i++;
            listenable.addListener(new Runnable(){

                @Override
                public void run() {
                    ListFuture.this.setOneValue(index, listenable);
                }
            }, listenerExecutor);
        }
    }

    /*
     * Exception decompiling
     */
    void setOneValue(int index, @NonNull Future<? extends V> future) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addListener(@NonNull Runnable listener, @NonNull Executor executor) {
        this.result.addListener(listener, executor);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.futures != null) {
            for (ListenableFuture<? extends V> listenableFuture : this.futures) {
                listenableFuture.cancel(mayInterruptIfRunning);
            }
        }
        return this.result.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.result.isCancelled();
    }

    public boolean isDone() {
        return this.result.isDone();
    }

    @Nullable
    public List<V> get() throws InterruptedException, ExecutionException {
        this.callAllGets();
        return (List)this.result.get();
    }

    public List<V> get(long timeout, @NonNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (List)this.result.get(timeout, unit);
    }

    private void callAllGets() throws InterruptedException {
        List<ListenableFuture<V>> oldFutures = this.futures;
        if (oldFutures != null && !this.isDone()) {
            for (ListenableFuture<? extends V> listenableFuture : oldFutures) {
                while (!listenableFuture.isDone()) {
                    try {
                        listenableFuture.get();
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        if (!this.allMustSucceed) continue;
                        return;
                    }
                }
            }
        }
    }
}

