/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.webdriver;

import androidx.annotation.VisibleForTesting;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.web.model.Atom;
import androidx.test.espresso.web.model.Atoms;
import androidx.test.espresso.web.model.ElementReference;
import androidx.test.espresso.web.model.Evaluation;
import androidx.test.espresso.web.model.SimpleAtom;
import androidx.test.espresso.web.model.TransformingAtom;
import androidx.test.espresso.web.model.WindowReference;
import androidx.test.espresso.web.webdriver.Locator;
import androidx.test.espresso.web.webdriver.WebDriverAtomScripts;
import androidx.test.internal.util.Checks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class DriverAtoms {
    private DriverAtoms() {
    }

    public static Atom<Evaluation> webClick() {
        return new WebClickSimpleAtom();
    }

    public static Atom<Evaluation> clearElement() {
        return new ClearElementSimpleAtom();
    }

    public static Atom<Evaluation> webKeys(String text) {
        return new WebKeysSimpleAtom((String)Checks.checkNotNull((Object)text));
    }

    public static Atom<ElementReference> findElement(Locator locator, String value) {
        return new FindElementTransformingAtom(new FindElementSimpleAtom(locator.getType(), value), Atoms.castOrDie(ElementReference.class));
    }

    public static Atom<ElementReference> selectActiveElement() {
        return new SelectActiveElementTransformingAtom(new ActiveElementSimpleAtom(), Atoms.castOrDie(ElementReference.class));
    }

    public static Atom<WindowReference> selectFrameByIndex(int index) {
        return new SelectFrameByIndexTransformingAtom(new FrameByIndexSimpleAtom(index), Atoms.castOrDie(WindowReference.class));
    }

    public static Atom<WindowReference> selectFrameByIndex(int index, WindowReference root) {
        return new SelectFrameByIndexTransformingAtom(new FrameByIndexWithRootSimpleAtom(index, (WindowReference)Checks.checkNotNull((Object)root)), Atoms.castOrDie(WindowReference.class));
    }

    public static Atom<WindowReference> selectFrameByIdOrName(String idOrName, WindowReference root) {
        return new SelectFrameByIdOrNameTransformingAtom(new FrameByIdOrNameWithRootSimpleAtom((String)Checks.checkNotNull((Object)idOrName), (WindowReference)Checks.checkNotNull((Object)root)), Atoms.castOrDie(WindowReference.class));
    }

    public static Atom<WindowReference> selectFrameByIdOrName(String idOrName) {
        return new SelectFrameByIdOrNameTransformingAtom(new FrameByIdOrNameSimpleAtom((String)Checks.checkNotNull((Object)idOrName)), Atoms.castOrDie(WindowReference.class));
    }

    public static Atom<String> getText() {
        return new GetTextTransformingAtom(new GetVisibleTextSimpleAtom(), Atoms.castOrDie(String.class));
    }

    public static Atom<Boolean> webScrollIntoView() {
        return new WebScrollIntoViewAtom(new WebScrollIntoViewSimpleAtom(), Atoms.castOrDie(Boolean.class));
    }

    public static Atom<List<ElementReference>> findMultipleElements(Locator locator, String value) {
        FindElementsScriptSimpleAtom findElementsScriptSimpleAtom = new FindElementsScriptSimpleAtom(locator.getType(), value);
        ElementReferenceListAtom elementReferenceListAtom = new ElementReferenceListAtom(locator.getType(), value);
        return new FindMultipleElementsTransformingAtom(findElementsScriptSimpleAtom, elementReferenceListAtom);
    }

    private static Map<String, String> makeLocatorJSON(Locator locator, String value) {
        Checks.checkNotNull((Object)((Object)locator));
        Checks.checkNotNull((Object)value);
        return Collections.singletonMap(locator.getType(), value);
    }

    static final class ElementReferenceListAtom
    implements TransformingAtom.Transformer<Evaluation, List<ElementReference>> {
        @RemoteMsgField(order=0)
        final String locatorType;
        @RemoteMsgField(order=1)
        final String value;

        @RemoteMsgConstructor
        private ElementReferenceListAtom(String locatorType, String value) {
            this.locatorType = locatorType;
            this.value = value;
        }

        @Override
        public List<ElementReference> apply(Evaluation e) {
            Object rawValues = e.getValue();
            if (null == rawValues) {
                return Collections.emptyList();
            }
            if (rawValues instanceof Iterable) {
                ArrayList<ElementReference> references = new ArrayList<ElementReference>();
                for (Object rawValue : (Iterable)rawValues) {
                    if (rawValue instanceof ElementReference) {
                        references.add((ElementReference)rawValue);
                        continue;
                    }
                    throw new RuntimeException(String.format("Unexpected non-elementReference in findMultipleElements(%s, %s): (%s) all: %s ", Locator.forType(this.locatorType).name(), this.value, rawValue, e));
                }
                return references;
            }
            throw new RuntimeException(String.format("Unexpected non-iterableType in findMultipleElements(%s, %s): return evaluation: %s ", Locator.forType(this.locatorType).name(), this.value, e));
        }
    }

    @VisibleForTesting
    static final class FindMultipleElementsTransformingAtom
    extends TransformingAtom<Evaluation, List<ElementReference>> {
        @RemoteMsgField(order=0)
        private final Atom<Evaluation> findElementsScriptSimpleAtom;
        @RemoteMsgField(order=1)
        private final TransformingAtom.Transformer<Evaluation, List<ElementReference>> elementReferenceListAtom;

        @RemoteMsgConstructor
        private FindMultipleElementsTransformingAtom(Atom<Evaluation> findElementsScriptSimpleAtom, TransformingAtom.Transformer<Evaluation, List<ElementReference>> elementReferenceListAtom) {
            super(findElementsScriptSimpleAtom, elementReferenceListAtom);
            this.findElementsScriptSimpleAtom = findElementsScriptSimpleAtom;
            this.elementReferenceListAtom = elementReferenceListAtom;
        }
    }

    @VisibleForTesting
    static final class FindElementsScriptSimpleAtom
    extends SimpleAtom {
        @RemoteMsgField(order=0)
        final String locatorType;
        @RemoteMsgField(order=1)
        final String value;

        @RemoteMsgConstructor
        private FindElementsScriptSimpleAtom(String locatorType, String value) {
            super(WebDriverAtomScripts.FIND_ELEMENTS_ANDROID);
            this.locatorType = locatorType;
            this.value = value;
        }

        @Override
        public List<Object> getNonContextualArguments() {
            return Collections.singletonList(DriverAtoms.makeLocatorJSON(Locator.forType(this.locatorType), this.value));
        }
    }

    @VisibleForTesting
    static final class SelectFrameByIdOrNameTransformingAtom
    extends TransformingAtom<Evaluation, WindowReference> {
        @RemoteMsgField(order=0)
        private final Atom<Evaluation> frameByIndexOrNameSimpleAtom;
        @RemoteMsgField(order=1)
        private final TransformingAtom.Transformer<Evaluation, WindowReference> castOrDieAtom;

        @RemoteMsgConstructor
        private SelectFrameByIdOrNameTransformingAtom(Atom<Evaluation> selectActiveElementSimpleAtom, TransformingAtom.Transformer<Evaluation, WindowReference> castOrDieAtom) {
            super(selectActiveElementSimpleAtom, castOrDieAtom);
            this.frameByIndexOrNameSimpleAtom = selectActiveElementSimpleAtom;
            this.castOrDieAtom = castOrDieAtom;
        }
    }

    @VisibleForTesting
    static final class FrameByIdOrNameWithRootSimpleAtom
    extends SimpleAtom {
        @RemoteMsgField(order=0)
        private final String idOrName;
        @RemoteMsgField(order=1)
        private final WindowReference root;

        @RemoteMsgConstructor
        private FrameByIdOrNameWithRootSimpleAtom(String idOrName, WindowReference root) {
            super(WebDriverAtomScripts.FRAME_BY_ID_OR_NAME_ANDROID);
            this.idOrName = idOrName;
            this.root = root;
        }

        @Override
        public List<Object> getNonContextualArguments() {
            return Arrays.asList(this.idOrName, this.root);
        }
    }

    @VisibleForTesting
    static final class FrameByIdOrNameSimpleAtom
    extends SimpleAtom {
        @RemoteMsgField(order=0)
        private final String idOrName;

        @RemoteMsgConstructor
        private FrameByIdOrNameSimpleAtom(String idOrName) {
            super(WebDriverAtomScripts.FRAME_BY_ID_OR_NAME_ANDROID);
            this.idOrName = idOrName;
        }

        @Override
        public List<Object> getNonContextualArguments() {
            return Collections.singletonList(this.idOrName);
        }
    }

    @VisibleForTesting
    static final class SelectFrameByIndexTransformingAtom
    extends TransformingAtom<Evaluation, WindowReference> {
        @RemoteMsgField(order=0)
        private final Atom<Evaluation> frameByIndexSimpleAtom;
        @RemoteMsgField(order=1)
        private final TransformingAtom.Transformer<Evaluation, WindowReference> castOrDieAtom;

        @RemoteMsgConstructor
        private SelectFrameByIndexTransformingAtom(Atom<Evaluation> selectActiveElementSimpleAtom, TransformingAtom.Transformer<Evaluation, WindowReference> castOrDieAtom) {
            super(selectActiveElementSimpleAtom, castOrDieAtom);
            this.frameByIndexSimpleAtom = selectActiveElementSimpleAtom;
            this.castOrDieAtom = castOrDieAtom;
        }
    }

    @VisibleForTesting
    static final class FrameByIndexWithRootSimpleAtom
    extends SimpleAtom {
        @RemoteMsgField(order=0)
        private final int index;
        @RemoteMsgField(order=1)
        private final WindowReference root;

        @RemoteMsgConstructor
        private FrameByIndexWithRootSimpleAtom(int index, WindowReference root) {
            super(WebDriverAtomScripts.FRAME_BY_INDEX_ANDROID);
            this.index = index;
            this.root = root;
        }

        @Override
        public List<Object> getNonContextualArguments() {
            return Arrays.asList(this.index, this.root);
        }
    }

    @VisibleForTesting
    static final class FrameByIndexSimpleAtom
    extends SimpleAtom {
        @RemoteMsgField(order=0)
        private final int index;

        @RemoteMsgConstructor
        private FrameByIndexSimpleAtom(int index) {
            super(WebDriverAtomScripts.FRAME_BY_INDEX_ANDROID);
            this.index = index;
        }

        @Override
        public List<Object> getNonContextualArguments() {
            return Collections.singletonList(this.index);
        }
    }

    @VisibleForTesting
    static final class SelectActiveElementTransformingAtom
    extends TransformingAtom<Evaluation, ElementReference> {
        @RemoteMsgField(order=0)
        private final Atom<Evaluation> selectActiveElementSimpleAtom;
        @RemoteMsgField(order=1)
        private final TransformingAtom.Transformer<Evaluation, ElementReference> castOrDieAtom;

        @RemoteMsgConstructor
        private SelectActiveElementTransformingAtom(Atom<Evaluation> selectActiveElementSimpleAtom, TransformingAtom.Transformer<Evaluation, ElementReference> castOrDieAtom) {
            super(selectActiveElementSimpleAtom, castOrDieAtom);
            this.selectActiveElementSimpleAtom = selectActiveElementSimpleAtom;
            this.castOrDieAtom = castOrDieAtom;
        }
    }

    @VisibleForTesting
    static final class ActiveElementSimpleAtom
    extends SimpleAtom {
        @RemoteMsgConstructor
        private ActiveElementSimpleAtom() {
            super(WebDriverAtomScripts.ACTIVE_ELEMENT_ANDROID);
        }
    }

    @VisibleForTesting
    static final class GetVisibleTextSimpleAtom
    extends SimpleAtom {
        @RemoteMsgConstructor
        private GetVisibleTextSimpleAtom() {
            super(WebDriverAtomScripts.GET_VISIBLE_TEXT_ANDROID);
        }
    }

    @VisibleForTesting
    static final class GetTextTransformingAtom
    extends TransformingAtom<Evaluation, String> {
        @RemoteMsgField(order=0)
        private final Atom<Evaluation> getTextSimpleAtom;
        @RemoteMsgField(order=1)
        private final TransformingAtom.Transformer<Evaluation, String> castOrDieAtom;

        @RemoteMsgConstructor
        private GetTextTransformingAtom(Atom<Evaluation> findElementSimpleAtom, TransformingAtom.Transformer<Evaluation, String> castOrDieAtom) {
            super(findElementSimpleAtom, castOrDieAtom);
            this.getTextSimpleAtom = findElementSimpleAtom;
            this.castOrDieAtom = castOrDieAtom;
        }
    }

    @VisibleForTesting
    static final class WebClickSimpleAtom
    extends SimpleAtom {
        @RemoteMsgConstructor
        private WebClickSimpleAtom() {
            super(WebDriverAtomScripts.CLICK_ANDROID);
        }

        @Override
        public void handleNoElementReference() {
            throw new RuntimeException("webClick: Need an element to click on!");
        }
    }

    static final class WebScrollIntoViewSimpleAtom
    extends SimpleAtom {
        @RemoteMsgConstructor
        private WebScrollIntoViewSimpleAtom() {
            super(WebDriverAtomScripts.SCROLL_INTO_VIEW_ANDROID);
        }

        @Override
        public void handleNoElementReference() {
            throw new RuntimeException("scrollIntoView: need an element to scroll to");
        }
    }

    @VisibleForTesting
    static final class WebScrollIntoViewAtom
    extends TransformingAtom<Evaluation, Boolean> {
        @RemoteMsgField(order=0)
        private final Atom<Evaluation> scrollIntoViewSimpleAtom;
        @RemoteMsgField(order=1)
        private final TransformingAtom.Transformer<Evaluation, Boolean> castOrDieAtom;

        @RemoteMsgConstructor
        private WebScrollIntoViewAtom(Atom<Evaluation> scrollIntoViewSimpleAtom, TransformingAtom.Transformer<Evaluation, Boolean> castOrDieAtom) {
            super(scrollIntoViewSimpleAtom, castOrDieAtom);
            this.scrollIntoViewSimpleAtom = scrollIntoViewSimpleAtom;
            this.castOrDieAtom = castOrDieAtom;
        }
    }

    @VisibleForTesting
    static final class WebKeysSimpleAtom
    extends SimpleAtom {
        @RemoteMsgField(order=0)
        private final String text;

        @RemoteMsgConstructor
        private WebKeysSimpleAtom(String text) {
            super(WebDriverAtomScripts.SEND_KEYS_ANDROID);
            this.text = text;
        }

        @Override
        public void handleNoElementReference() {
            throw new RuntimeException("webKeys: Need an element to type on!");
        }

        @Override
        public List<Object> getNonContextualArguments() {
            return Collections.singletonList(this.text);
        }
    }

    @VisibleForTesting
    static final class ClearElementSimpleAtom
    extends SimpleAtom {
        @RemoteMsgConstructor
        private ClearElementSimpleAtom() {
            super(WebDriverAtomScripts.CLEAR_ANDROID);
        }

        @Override
        public void handleNoElementReference() {
            throw new RuntimeException("clearElement: Need an element to clear!");
        }
    }

    @VisibleForTesting
    static final class FindElementTransformingAtom
    extends TransformingAtom<Evaluation, ElementReference> {
        @RemoteMsgField(order=0)
        private final Atom<Evaluation> findElementSimpleAtom;
        @RemoteMsgField(order=1)
        private final TransformingAtom.Transformer<Evaluation, ElementReference> castOrDieAtom;

        @RemoteMsgConstructor
        private FindElementTransformingAtom(Atom<Evaluation> findElementSimpleAtom, TransformingAtom.Transformer<Evaluation, ElementReference> castOrDieAtom) {
            super(findElementSimpleAtom, castOrDieAtom);
            this.findElementSimpleAtom = findElementSimpleAtom;
            this.castOrDieAtom = castOrDieAtom;
        }
    }

    @VisibleForTesting
    static final class FindElementSimpleAtom
    extends SimpleAtom {
        @RemoteMsgField(order=0)
        final String locatorType;
        @RemoteMsgField(order=1)
        final String value;

        @RemoteMsgConstructor
        FindElementSimpleAtom(String locatorType, String value) {
            super(WebDriverAtomScripts.FIND_ELEMENT_ANDROID, SimpleAtom.ElementReferencePlacement.LAST);
            this.locatorType = locatorType;
            this.value = value;
        }

        @Override
        protected List<Object> getNonContextualArguments() {
            Map locatorJson = DriverAtoms.makeLocatorJSON(Locator.forType(this.locatorType), this.value);
            return Collections.singletonList(locatorJson);
        }
    }
}

