/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.webdriver;

public enum Locator {
    CLASS_NAME("className"),
    CSS_SELECTOR("css"),
    ID("id"),
    LINK_TEXT("linkText"),
    NAME("name"),
    PARTIAL_LINK_TEXT("partialLinkText"),
    TAG_NAME("tagName"),
    XPATH("xpath");

    private final String type;

    private Locator(String type) {
        this.type = type;
    }

    static Locator forType(String type) {
        if (CLASS_NAME.getType().equals(type)) {
            return CLASS_NAME;
        }
        if (CSS_SELECTOR.getType().equals(type)) {
            return CSS_SELECTOR;
        }
        if (ID.getType().equals(type)) {
            return ID;
        }
        if (LINK_TEXT.getType().equals(type)) {
            return LINK_TEXT;
        }
        if (NAME.getType().equals(type)) {
            return NAME;
        }
        if (PARTIAL_LINK_TEXT.getType().equals(type)) {
            return PARTIAL_LINK_TEXT;
        }
        if (TAG_NAME.getType().equals(type)) {
            return TAG_NAME;
        }
        if (XPATH.getType().equals(type)) {
            return XPATH;
        }
        throw new IllegalStateException("No Locator enum found for a given type: " + type);
    }

    public String getType() {
        return this.type;
    }
}

