/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.ext.junit.runners;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;

public final class AndroidJUnit4
extends Runner
implements Filterable,
Sortable {
    private static final String TAG = "AndroidJUnit4";
    private final Runner delegate;

    public AndroidJUnit4(Class<?> klass) throws InitializationError {
        this.delegate = AndroidJUnit4.loadRunner(klass);
    }

    private static String getRunnerClassName() {
        String runnerClassName = System.getProperty("android.junit.runner", null);
        if (runnerClassName == null) {
            if (!System.getProperty("java.runtime.name").toLowerCase().contains("android") && AndroidJUnit4.hasClass("org.robolectric.RobolectricTestRunner")) {
                return "org.robolectric.RobolectricTestRunner";
            }
            return "androidx.test.internal.runner.junit4.AndroidJUnit4ClassRunner";
        }
        return runnerClassName;
    }

    private static boolean hasClass(String className) {
        try {
            return Class.forName(className) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static Runner loadRunner(Class<?> testClass) throws InitializationError {
        String runnerClassName = AndroidJUnit4.getRunnerClassName();
        return AndroidJUnit4.loadRunner(testClass, runnerClassName);
    }

    private static Runner loadRunner(Class<?> testClass, String runnerClassName) throws InitializationError {
        Class<?> runnerClass = null;
        try {
            runnerClass = Class.forName(runnerClassName);
        }
        catch (ClassNotFoundException e) {
            AndroidJUnit4.throwInitializationError(String.format("Delegate runner %s for AndroidJUnit4 could not be found.\n", runnerClassName), e);
        }
        Constructor<?> constructor = null;
        try {
            constructor = runnerClass.getConstructor(Class.class);
        }
        catch (NoSuchMethodException e) {
            AndroidJUnit4.throwInitializationError(String.format("Delegate runner %s for AndroidJUnit4 requires a public constructor that takes a Class<?>.\n", runnerClassName), e);
        }
        try {
            return (Runner)constructor.newInstance(testClass);
        }
        catch (IllegalAccessException e) {
            AndroidJUnit4.throwInitializationError(String.format("Illegal constructor access for test runner %s\n", runnerClassName), e);
        }
        catch (InstantiationException e) {
            AndroidJUnit4.throwInitializationError(String.format("Failed to instantiate test runner %s\n", runnerClassName), e);
        }
        catch (InvocationTargetException e) {
            String details = AndroidJUnit4.getInitializationErrorDetails(e, testClass);
            AndroidJUnit4.throwInitializationError(String.format("Failed to instantiate test runner %s\n%s\n", runnerClass, details), e);
        }
        throw new IllegalStateException("Should never reach here");
    }

    private static void throwInitializationError(String details, Throwable cause) throws InitializationError {
        throw new InitializationError((Throwable)new RuntimeException(details, cause));
    }

    private static String getInitializationErrorDetails(Throwable throwable, Class<?> testClass) {
        StringBuilder innerCause = new StringBuilder();
        Throwable cause = throwable.getCause();
        if (cause == null) {
            return "";
        }
        Class<?> causeClass = cause.getClass();
        if (causeClass == InitializationError.class) {
            InitializationError initializationError = (InitializationError)cause;
            List testClassProblemList = initializationError.getCauses();
            innerCause.append(String.format("Test class %s is malformed. (%s problems):\n", testClass, testClassProblemList.size()));
            for (Throwable testClassProblem : testClassProblemList) {
                innerCause.append(testClassProblem).append("\n");
            }
        }
        return innerCause.toString();
    }

    public Description getDescription() {
        return this.delegate.getDescription();
    }

    public void run(RunNotifier runNotifier) {
        this.delegate.run(runNotifier);
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        ((Filterable)this.delegate).filter(filter);
    }

    public void sort(Sorter sorter) {
        ((Sortable)this.delegate).sort(sorter);
    }
}

