/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner;

import android.text.TextUtils;
import androidx.test.internal.runner.RunnerArgs;
import java.util.ArrayList;
import java.util.List;

class ClassesArgTokenizer {
    private static final String TAG = "ClassesArgTokenizer";

    private ClassesArgTokenizer() {
    }

    static List<RunnerArgs.TestArg> parse(String input) {
        ArrayList<RunnerArgs.TestArg> testargs = new ArrayList<RunnerArgs.TestArg>();
        if (!TextUtils.isEmpty((CharSequence)input)) {
            for (TokenizerState state = new ClassTokenizerState(testargs, input, 0); state != null; state = ((TokenizerState)state).parse()) {
            }
        }
        return testargs;
    }

    private static class MethodTokenizerState
    extends TokenizerState {
        private final String className;

        protected MethodTokenizerState(List<RunnerArgs.TestArg> testArgs, String input, int pos, String className) {
            super(testArgs, input, pos);
            this.className = className;
        }

        @Override
        TokenizerState parse() {
            while (this.pos < this.input.length()) {
                if (this.input.charAt(this.pos) == ',') {
                    String methodName = this.input.substring(this.startTokenPos, this.pos);
                    this.testArgs.add(new RunnerArgs.TestArg(this.className, methodName));
                    return new ClassTokenizerState(this.testArgs, this.input, this.pos + 1).parse();
                }
                if (this.input.charAt(this.pos) == '[') {
                    this.pos = this.input.indexOf(93, this.pos);
                    if (this.pos <= 0) {
                        throw new IllegalStateException("Could not find closing param ] in input " + this.input);
                    }
                }
                if (this.input.charAt(this.pos) == '(') {
                    this.pos = this.input.indexOf(41, this.pos);
                    if (this.pos <= 0) {
                        throw new IllegalStateException("Could not find closing param ) in input " + this.input);
                    }
                }
                ++this.pos;
            }
            if (this.pos > this.startTokenPos) {
                String methodName = this.input.substring(this.startTokenPos, this.pos);
                this.testArgs.add(new RunnerArgs.TestArg(this.className, methodName));
            }
            return null;
        }
    }

    private static class ClassTokenizerState
    extends TokenizerState {
        private ClassTokenizerState(List<RunnerArgs.TestArg> testArgs, String input, int pos) {
            super(testArgs, input, pos);
        }

        @Override
        TokenizerState parse() {
            while (this.pos < this.input.length()) {
                if (this.input.charAt(this.pos) == '#') {
                    String className = this.input.substring(this.startTokenPos, this.pos);
                    return new MethodTokenizerState(this.testArgs, this.input, this.pos + 1, className).parse();
                }
                if (this.input.charAt(this.pos) == ',') {
                    String className = this.input.substring(this.startTokenPos, this.pos);
                    this.testArgs.add(new RunnerArgs.TestArg(className));
                    return new ClassTokenizerState(this.testArgs, this.input, this.pos + 1);
                }
                ++this.pos;
            }
            if (this.pos > this.startTokenPos) {
                String className = this.input.substring(this.startTokenPos, this.pos);
                this.testArgs.add(new RunnerArgs.TestArg(className));
            }
            return null;
        }
    }

    private static abstract class TokenizerState {
        protected final List<RunnerArgs.TestArg> testArgs;
        protected final String input;
        protected final int startTokenPos;
        protected int pos;

        protected TokenizerState(List<RunnerArgs.TestArg> testArgs, String input, int pos) {
            this.testArgs = testArgs;
            this.input = input;
            this.pos = pos;
            this.startTokenPos = pos;
        }

        abstract TokenizerState parse();
    }
}

