/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.adselection;

import android.adservices.common.AdTechIdentifier;

/**
 * Represents a request containing the information to get ad selection data.
 *
 * <p>Instances of this class are created by SDKs to be provided as arguments to the {@link android.adservices.adselection.AdSelectionManager#getAdSelectionData  } methods in {@link android.adservices.adselection.AdSelectionManager AdSelectionManager}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class GetAdSelectionDataRequest {

GetAdSelectionDataRequest() { throw new RuntimeException("Stub!"); }

/**
 * @return a AdTechIdentifier of the seller, for example "www.example-ssp.com"

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.adservices.common.AdTechIdentifier getSeller() { throw new RuntimeException("Stub!"); }
/**
 * Builder for {@link android.adservices.adselection.GetAdSelectionDataRequest GetAdSelectionDataRequest} objects.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Sets the seller {@link android.adservices.common.AdTechIdentifier AdTechIdentifier}.
 * @param seller This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.GetAdSelectionDataRequest.Builder setSeller(@android.annotation.Nullable android.adservices.common.AdTechIdentifier seller) { throw new RuntimeException("Stub!"); }

/**
 * Builds a {@link android.adservices.adselection.GetAdSelectionDataRequest GetAdSelectionDataRequest} instance.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.GetAdSelectionDataRequest build() { throw new RuntimeException("Stub!"); }
}

}

