/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.adselection;

import java.util.concurrent.Executor;

/**
 * {@link android.adservices.adselection.TestAdSelectionManager TestAdSelectionManager} provides APIs for apps and ad SDKs to test ad selection processes.
 *
 * <p>These APIs are intended to be used for end-to-end testing. They are enabled only for
 * debuggable apps on phones running a debuggable OS build with developer options enabled.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class TestAdSelectionManager {

TestAdSelectionManager() { throw new RuntimeException("Stub!"); }

/**
 * Overrides the AdSelection API for a given {@link android.adservices.adselection.AdSelectionConfig AdSelectionConfig} to avoid fetching data
 * from remote servers and use the data provided in {@link android.adservices.adselection.AddAdSelectionOverrideRequest AddAdSelectionOverrideRequest}
 * instead. The {@link android.adservices.adselection.AddAdSelectionOverrideRequest AddAdSelectionOverrideRequest} is provided by the Ads SDK.
 *
 * <p>This method is intended to be used for end-to-end testing. This API is enabled only for
 * apps in debug mode with developer options enabled.
 *
 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_CUSTOM_AUDIENCE}
 * @throws java.lang.IllegalStateException if this API is not enabled for the caller
 *     <p>The receiver either returns a {@code void} for a successful run, or an {@link java.lang.Exception Exception} indicates the error.
 
 * @param request This value cannot be {@code null}.

 * @param executor This value cannot be {@code null}.
 
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.

 * @param receiver This value cannot be {@code null}.
 */

public void overrideAdSelectionConfigRemoteInfo(@android.annotation.NonNull android.adservices.adselection.AddAdSelectionOverrideRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Object,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }

/**
 * Removes an override for {@link android.adservices.adselection.AdSelectionConfig AdSelectionConfig} in the Ad Selection API with associated the
 * data in {@link android.adservices.adselection.RemoveAdSelectionOverrideRequest RemoveAdSelectionOverrideRequest}. The {@link android.adservices.adselection.RemoveAdSelectionOverrideRequest RemoveAdSelectionOverrideRequest} is provided by the Ads SDK.
 *
 * <p>This method is intended to be used for end-to-end testing. This API is enabled only for
 * apps in debug mode with developer options enabled.
 *
 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_CUSTOM_AUDIENCE}
 * @throws java.lang.IllegalStateException if this API is not enabled for the caller
 *     <p>The receiver either returns a {@code void} for a successful run, or an {@link java.lang.Exception Exception} indicates the error.
 
 * @param request This value cannot be {@code null}.

 * @param executor This value cannot be {@code null}.
 
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.

 * @param receiver This value cannot be {@code null}.
 */

public void removeAdSelectionConfigRemoteInfoOverride(@android.annotation.NonNull android.adservices.adselection.RemoveAdSelectionOverrideRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Object,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }

/**
 * Removes all override data for {@link android.adservices.adselection.AdSelectionConfig AdSelectionConfig} in the Ad Selection API.
 *
 * <p>This method is intended to be used for end-to-end testing. This API is enabled only for
 * apps in debug mode with developer options enabled.
 *
 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_CUSTOM_AUDIENCE}
 * @throws java.lang.IllegalStateException if this API is not enabled for the caller
 *     <p>The receiver either returns a {@code void} for a successful run, or an {@link java.lang.Exception Exception} indicates the error.

 * @param executor This value cannot be {@code null}.
 
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.

 * @param receiver This value cannot be {@code null}.
 */

public void resetAllAdSelectionConfigRemoteOverrides(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Object,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }

/**
 * Overrides the AdSelection API for {@link android.adservices.adselection.AdSelectionFromOutcomesConfig AdSelectionFromOutcomesConfig} to avoid fetching
 * data from remote servers and use the data provided in {@link android.adservices.adselection.AddAdSelectionFromOutcomesOverrideRequest AddAdSelectionFromOutcomesOverrideRequest} instead. The {@link android.adservices.adselection.AddAdSelectionFromOutcomesOverrideRequest AddAdSelectionFromOutcomesOverrideRequest} is provided by the Ads SDK.
 *
 * <p>This method is intended to be used for end-to-end testing. This API is enabled only for
 * apps in debug mode with developer options enabled.
 *
 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_CUSTOM_AUDIENCE}
 * @throws java.lang.IllegalStateException if this API is not enabled for the caller
 *     <p>The receiver either returns a {@code void} for a successful run, or an {@link java.lang.Exception Exception} indicates the error.
 
 * @param request This value cannot be {@code null}.

 * @param executor This value cannot be {@code null}.
 
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.

 * @param receiver This value cannot be {@code null}.
 */

public void overrideAdSelectionFromOutcomesConfigRemoteInfo(@android.annotation.NonNull android.adservices.adselection.AddAdSelectionFromOutcomesOverrideRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Object,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }

/**
 * Removes an override for {@link android.adservices.adselection.AdSelectionFromOutcomesConfig AdSelectionFromOutcomesConfig} in th Ad Selection API with
 * associated the data in {@link android.adservices.adselection.RemoveAdSelectionOverrideRequest RemoveAdSelectionOverrideRequest}. The {@link android.adservices.adselection.RemoveAdSelectionOverrideRequest RemoveAdSelectionOverrideRequest} is provided by the Ads SDK.
 *
 * <p>This method is intended to be used for end-to-end testing. This API is enabled only for
 * apps in debug mode with developer options enabled.
 *
 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_CUSTOM_AUDIENCE}
 * @throws java.lang.IllegalStateException if this API is not enabled for the caller
 *     <p>The receiver either returns a {@code void} for a successful run, or an {@link java.lang.Exception Exception} indicates the error.
 
 * @param request This value cannot be {@code null}.

 * @param executor This value cannot be {@code null}.
 
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.

 * @param receiver This value cannot be {@code null}.
 */

public void removeAdSelectionFromOutcomesConfigRemoteInfoOverride(@android.annotation.NonNull android.adservices.adselection.RemoveAdSelectionFromOutcomesOverrideRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Object,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }

/**
 * Removes all override data for {@link android.adservices.adselection.AdSelectionFromOutcomesConfig AdSelectionFromOutcomesConfig} in the Ad Selection API.
 *
 * <p>This method is intended to be used for end-to-end testing. This API is enabled only for
 * apps in debug mode with developer options enabled.
 *
 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_CUSTOM_AUDIENCE}
 * @throws java.lang.IllegalStateException if this API is not enabled for the caller
 *     <p>The receiver either returns a {@code void} for a successful run, or an {@link java.lang.Exception Exception} indicates the error.

 * @param executor This value cannot be {@code null}.
 
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.

 * @param receiver This value cannot be {@code null}.
 */

public void resetAllAdSelectionFromOutcomesConfigRemoteOverrides(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Object,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }
}

