/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.customaudience;

import android.adservices.common.AdTechIdentifier;
import android.os.OutcomeReceiver;
import java.util.concurrent.Executor;

/**
 * This POJO represents the {@link android.adservices.customaudience.TestCustomAudienceManager#overrideCustomAudienceRemoteInfo(android.adservices.customaudience.AddCustomAudienceOverrideRequest,java.util.concurrent.Executor,android.os.OutcomeReceiver)  } request.
 *
 * <p>It contains fields {@code buyer} and {@code name} which will serve as the identifier for the
 * override fields, {@code biddingLogicJs} and {@code trustedBiddingSignals}, which are used during
 * ad selection instead of querying external servers.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class AddCustomAudienceOverrideRequest {

/**
 * @param buyer This value cannot be {@code null}.

 * @param name This value cannot be {@code null}.
 
 * @param biddingLogicJs This value cannot be {@code null}.

 * @param trustedBiddingSignals This value cannot be {@code null}.
 */

public AddCustomAudienceOverrideRequest(@android.annotation.NonNull android.adservices.common.AdTechIdentifier buyer, @android.annotation.NonNull java.lang.String name, @android.annotation.NonNull java.lang.String biddingLogicJs, @android.annotation.NonNull android.adservices.common.AdSelectionSignals trustedBiddingSignals) { throw new RuntimeException("Stub!"); }

/**
 * @return an {@link android.adservices.common.AdTechIdentifier AdTechIdentifier} representing the buyer
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.AdTechIdentifier getBuyer() { throw new RuntimeException("Stub!"); }

/**
 * @return name of the custom audience being overridden
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getName() { throw new RuntimeException("Stub!"); }

/**
 * @return the override JavaScript result that should be served during ad selection
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getBiddingLogicJs() { throw new RuntimeException("Stub!"); }

/**
 * @return the override trusted bidding signals that should be served during ad selection
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.AdSelectionSignals getTrustedBiddingSignals() { throw new RuntimeException("Stub!"); }
/** Builder for {@link android.adservices.customaudience.AddCustomAudienceOverrideRequest AddCustomAudienceOverrideRequest} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Sets the buyer {@link android.adservices.common.AdTechIdentifier AdTechIdentifier} for the custom audience.
 * @param buyer This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.AddCustomAudienceOverrideRequest.Builder setBuyer(@android.annotation.NonNull android.adservices.common.AdTechIdentifier buyer) { throw new RuntimeException("Stub!"); }

/**
 * Sets the name for the custom audience to be overridden.
 * @param name This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.AddCustomAudienceOverrideRequest.Builder setName(@android.annotation.NonNull java.lang.String name) { throw new RuntimeException("Stub!"); }

/**
 * Sets the trusted bidding signals to be served during ad selection.
 * @param trustedBiddingSignals This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.AddCustomAudienceOverrideRequest.Builder setTrustedBiddingSignals(@android.annotation.NonNull android.adservices.common.AdSelectionSignals trustedBiddingSignals) { throw new RuntimeException("Stub!"); }

/**
 * Sets the bidding logic JavaScript that should be served during ad selection.
 * @param biddingLogicJs This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.AddCustomAudienceOverrideRequest.Builder setBiddingLogicJs(@android.annotation.NonNull java.lang.String biddingLogicJs) { throw new RuntimeException("Stub!"); }

/**
 * Builds a {@link android.adservices.customaudience.AddCustomAudienceOverrideRequest AddCustomAudienceOverrideRequest} instance.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.AddCustomAudienceOverrideRequest build() { throw new RuntimeException("Stub!"); }
}

}

