/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.adselection;

import android.adservices.customaudience.CustomAudience;

/**
 * The override object for decision logic JS per buyer for {@link android.adservices.adselection.SignedContextualAds SignedContextualAds}.
 *
 * <p>This decision logic is used for reporting when an ad wins from a buyer's bundle of {@link android.adservices.adselection.SignedContextualAds SignedContextualAds}.
 *
 * <p>This JS code may be extended to updating bid values for contextual ads in the future.
 *
 * <p>See {@link android.adservices.customaudience.CustomAudience#getBiddingLogicUri() CustomAudience#getBiddingLogicUri()}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class PerBuyerDecisionLogic implements android.os.Parcelable {

/**
 * Builds a {@link android.adservices.adselection.PerBuyerDecisionLogic PerBuyerDecisionLogic} instance.
 *
 * @param perBuyerLogicMap map of buyers and their decision logic to be fetched during ad
 *     selection

 * This value cannot be {@code null}.
 */

public PerBuyerDecisionLogic(@android.annotation.NonNull java.util.Map<android.adservices.common.AdTechIdentifier,android.adservices.adselection.DecisionLogic> perBuyerLogicMap) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Map<android.adservices.common.AdTechIdentifier,android.adservices.adselection.DecisionLogic> getPerBuyerLogicMap() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.adservices.adselection.PerBuyerDecisionLogic> CREATOR;
static { CREATOR = null; }

@android.annotation.NonNull public static final android.adservices.adselection.PerBuyerDecisionLogic EMPTY;
static { EMPTY = null; }
}

