/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.common;


/** Represents data specific to an ad that is necessary for ad selection and rendering. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class AdData implements android.os.Parcelable {

AdData() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** @hide */

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Gets the URI that points to the ad's rendering assets. The URI must use HTTPS.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.Uri getRenderUri() { throw new RuntimeException("Stub!"); }

/**
 * Gets the buyer ad metadata used during the ad selection process.
 *
 * <p>The metadata should be a valid JSON object serialized as a string. Metadata represents
 * ad-specific bidding information that will be used during ad selection as part of bid
 * generation and used in buyer JavaScript logic, which is executed in an isolated execution
 * environment.
 *
 * <p>If the metadata is not a valid JSON object that can be consumed by the buyer's JS, the ad
 * will not be eligible for ad selection.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getMetadata() { throw new RuntimeException("Stub!"); }

/**
 * Gets the set of keys used in counting events.
 *
 * <p>No more than 10 ad counter keys may be associated with an ad.
 *
 * <p>The keys and counts per key are used in frequency cap filtering during ad selection to
 * disqualify associated ads from being submitted to bidding.
 *
 * <p>Note that these keys can be overwritten along with the ads and other bidding data for a
 * custom audience during the custom audience's daily update.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<java.lang.Integer> getAdCounterKeys() { throw new RuntimeException("Stub!"); }

/**
 * Gets all {@link android.adservices.common.AdFilters AdFilters} associated with the ad.
 *
 * <p>The filters, if met or exceeded, exclude the associated ad from participating in ad
 * selection. They are optional and if {@code null} specify that no filters apply to this ad.
 */

@android.annotation.Nullable
public android.adservices.common.AdFilters getAdFilters() { throw new RuntimeException("Stub!"); }

/**
 * Gets the ad render id for server auctions.
 *
 * <p>Ad render id is collected for each {@link android.adservices.common.AdData AdData} when server auction request is received.
 *
 * <p>Any {@link android.adservices.common.AdData AdData} without ad render id will be ineligible for server-side auction.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public java.lang.String getAdRenderId() { throw new RuntimeException("Stub!"); }

/** Checks whether two {@link android.adservices.common.AdData AdData} objects contain the same information. */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/** Returns the hash of the {@link android.adservices.common.AdData AdData} object's data. */

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.adservices.common.AdData> CREATOR;
static { CREATOR = null; }
/** Builder for {@link android.adservices.common.AdData AdData} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Sets the URI that points to the ad's rendering assets. The URI must use HTTPS.
 *
 * <p>See {@link #getRenderUri()} for detail.
 
 * @param renderUri This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.AdData.Builder setRenderUri(@android.annotation.NonNull android.net.Uri renderUri) { throw new RuntimeException("Stub!"); }

/**
 * Sets the buyer ad metadata used during the ad selection process.
 *
 * <p>The metadata should be a valid JSON object serialized as a string. Metadata represents
 * ad-specific bidding information that will be used during ad selection as part of bid
 * generation and used in buyer JavaScript logic, which is executed in an isolated execution
 * environment.
 *
 * <p>If the metadata is not a valid JSON object that can be consumed by the buyer's JS, the
 * ad will not be eligible for ad selection.
 *
 * <p>See {@link #getMetadata()} for detail.
 
 * @param metadata This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.AdData.Builder setMetadata(@android.annotation.NonNull java.lang.String metadata) { throw new RuntimeException("Stub!"); }

/**
 * Sets the set of keys used in counting events.
 *
 * <p>No more than 10 ad counter keys may be associated with an ad.
 *
 * <p>See {@link #getAdCounterKeys()} for more information.
 
 * @param adCounterKeys This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.AdData.Builder setAdCounterKeys(@android.annotation.NonNull java.util.Set<java.lang.Integer> adCounterKeys) { throw new RuntimeException("Stub!"); }

/**
 * Sets all {@link android.adservices.common.AdFilters AdFilters} associated with the ad.
 *
 * <p>See {@link #getAdFilters()} for more information.
 
 * @param adFilters This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.AdData.Builder setAdFilters(@android.annotation.Nullable android.adservices.common.AdFilters adFilters) { throw new RuntimeException("Stub!"); }

/**
 * Sets the ad render id for server auction
 *
 * <p>See {@link android.adservices.common.AdData#getAdRenderId() AdData#getAdRenderId()} for more information.
 
 * @param adRenderId This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.AdData.Builder setAdRenderId(@android.annotation.Nullable java.lang.String adRenderId) { throw new RuntimeException("Stub!"); }

/**
 * Builds the {@link android.adservices.common.AdData AdData} object.
 *
 * @throws java.lang.NullPointerException if any required parameters are {@code null} when built

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.AdData build() { throw new RuntimeException("Stub!"); }
}

}

