/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.customaudience;

import android.adservices.adselection.GetAdSelectionDataRequest;
import android.adservices.common.AdData;
import android.adservices.common.AdSelectionSignals;
import android.adservices.common.AdTechIdentifier;
import android.os.OutcomeReceiver;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.Executor;

/**
 * Represents the information necessary for a custom audience to participate in ad selection.
 *
 * <p>A custom audience is an abstract grouping of users with similar demonstrated interests. This
 * class is a collection of some data stored on a device that is necessary to serve advertisements
 * targeting a single custom audience.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class CustomAudience implements android.os.Parcelable {

CustomAudience() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/** @hide */

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * A buyer is identified by a domain in the form "buyerexample.com".
 *
 * @return an {@link android.adservices.common.AdTechIdentifier AdTechIdentifier} containing the custom audience's buyer's domain

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.AdTechIdentifier getBuyer() { throw new RuntimeException("Stub!"); }

/**
 * The custom audience's name is an arbitrary string provided by the owner and buyer on creation
 * of the {@link android.adservices.customaudience.CustomAudience CustomAudience} object.
 *
 * @return the String name of the custom audience

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getName() { throw new RuntimeException("Stub!"); }

/**
 * On creation of the {@link android.adservices.customaudience.CustomAudience CustomAudience} object, an optional activation time may be set in
 * the future, in order to serve a delayed activation. If the field is not set, the {@link android.adservices.customaudience.CustomAudience CustomAudience} will be activated at the time of joining.
 *
 * <p>For example, a custom audience for lapsed users may not activate until a threshold of
 * inactivity is reached, at which point the custom audience's ads will participate in the ad
 * selection process, potentially redirecting lapsed users to the original owner application.
 *
 * <p>The maximum delay in activation is 60 days from initial creation.
 *
 * <p>If specified, the activation time must be an earlier instant than the expiration time.
 *
 * @return the timestamp {@link java.time.Instant Instant}, truncated to milliseconds, after which the custom
 *     audience is active

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public java.time.Instant getActivationTime() { throw new RuntimeException("Stub!"); }

/**
 * Once the expiration time has passed, a custom audience is no longer eligible for daily
 * ad/bidding data updates or participation in the ad selection process. The custom audience
 * will then be deleted from memory by the next daily update.
 *
 * <p>If no expiration time is provided on creation of the {@link android.adservices.customaudience.CustomAudience CustomAudience}, expiry will
 * default to 60 days from activation.
 *
 * <p>The maximum expiry is 60 days from initial activation.
 *
 * @return the timestamp {@link java.time.Instant Instant}, truncated to milliseconds, after which the custom
 *     audience should be removed

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public java.time.Instant getExpirationTime() { throw new RuntimeException("Stub!"); }

/**
 * This URI points to a buyer-operated server that hosts updated bidding data and ads metadata
 * to be used in the on-device ad selection process. The URI must use HTTPS.
 *
 * @return the custom audience's daily update URI

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.Uri getDailyUpdateUri() { throw new RuntimeException("Stub!"); }

/**
 * User bidding signals are optionally provided by buyers to be consumed by buyer-provided
 * JavaScript during ad selection in an isolated execution environment.
 *
 * <p>If the user bidding signals are not a valid JSON object that can be consumed by the
 * buyer's JS, the custom audience will not be eligible for ad selection.
 *
 * <p>If not specified, the {@link android.adservices.customaudience.CustomAudience CustomAudience} will not participate in ad selection until
 * user bidding signals are provided via the daily update for the custom audience.
 *
 * @return an {@link android.adservices.common.AdSelectionSignals AdSelectionSignals} object representing the user bidding signals for the
 *     custom audience

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.adservices.common.AdSelectionSignals getUserBiddingSignals() { throw new RuntimeException("Stub!"); }

/**
 * Trusted bidding data consists of a URI pointing to a trusted server for buyers' bidding data
 * and a list of keys to query the server with. Note that the keys are arbitrary identifiers
 * that will only be used to query the trusted server for a buyer's bidding logic during ad
 * selection.
 *
 * <p>If not specified, the {@link android.adservices.customaudience.CustomAudience CustomAudience} will not participate in ad selection until
 * trusted bidding data are provided via the daily update for the custom audience.
 *
 * @return a {@link android.adservices.customaudience.TrustedBiddingData TrustedBiddingData} object containing the custom audience's trusted bidding
 *     data

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.adservices.customaudience.TrustedBiddingData getTrustedBiddingData() { throw new RuntimeException("Stub!"); }

/**
 * Returns the target URI used to fetch bidding logic when a custom audience participates in the
 * ad selection process. The URI must use HTTPS.
 *
 * @return the URI for fetching buyer bidding logic

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.Uri getBiddingLogicUri() { throw new RuntimeException("Stub!"); }

/**
 * This list of {@link android.adservices.common.AdData AdData} objects is a full and complete list of the ads that will be
 * served by this {@link android.adservices.customaudience.CustomAudience CustomAudience} during the ad selection process.
 *
 * <p>If not specified, or if an empty list is provided, the {@link android.adservices.customaudience.CustomAudience CustomAudience} will not
 * participate in ad selection until a valid list of ads are provided via the daily update for
 * the custom audience.
 *
 * @return a {@link java.util.List List} of {@link android.adservices.common.AdData AdData} objects representing ads currently served by the
 *     custom audience

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.adservices.common.AdData> getAds() { throw new RuntimeException("Stub!"); }

/**
 * Returns the bitfield of auction server request flags. These are flags that influence the
 * creation of the payload generated by the {@link
 * android.adservices.adselection.AdSelectionManager#getAdSelectionData(GetAdSelectionDataRequest,
 * Executor, OutcomeReceiver)} API.
 *
 * <p>To create this bitfield, place an {@code |} bitwise operator between each {@link android.adservices.customaudience.CustomAudience.AuctionServerRequestFlag AuctionServerRequestFlag} to be enabled.

 * @return Value is either <code>0</code> or a combination of android.adservices.customaudience.CustomAudience.FLAG_AUCTION_SERVER_REQUEST_DEFAULT, and {@link android.adservices.customaudience.CustomAudience#FLAG_AUCTION_SERVER_REQUEST_OMIT_ADS}
 */

public int getAuctionServerRequestFlags() { throw new RuntimeException("Stub!"); }

/**
 * Checks whether two {@link android.adservices.customaudience.CustomAudience CustomAudience} objects contain the same information.
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the hash of the {@link android.adservices.customaudience.CustomAudience CustomAudience} object's data.
 */

public int hashCode() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.adservices.customaudience.CustomAudience> CREATOR;
static { CREATOR = null; }

/**
 * This auction server request flag indicates to the service that ads for this {@link android.adservices.customaudience.CustomAudience CustomAudience} can be omitted in the server auction payload.
 */

public static final int FLAG_AUCTION_SERVER_REQUEST_OMIT_ADS = 1; // 0x1
/** Builder for {@link android.adservices.customaudience.CustomAudience CustomAudience} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Sets the buyer {@link android.adservices.common.AdTechIdentifier AdTechIdentifier}.
 *
 * <p>See {@link #getBuyer()} for more information.
 
 * @param buyer This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.CustomAudience.Builder setBuyer(@android.annotation.NonNull android.adservices.common.AdTechIdentifier buyer) { throw new RuntimeException("Stub!"); }

/**
 * Sets the {@link android.adservices.customaudience.CustomAudience CustomAudience} object's name.
 * <p>
 * See {@link #getName()} for more information.
 
 * @param name This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.CustomAudience.Builder setName(@android.annotation.NonNull java.lang.String name) { throw new RuntimeException("Stub!"); }

/**
 * Sets the time, truncated to milliseconds, after which the {@link android.adservices.customaudience.CustomAudience CustomAudience} will
 * serve ads.
 *
 * <p>Set to {@code null} in order for this {@link android.adservices.customaudience.CustomAudience CustomAudience} to be immediately active
 * and participate in ad selection.
 *
 * <p>See {@link #getActivationTime()} for more information.

 * @param activationTime This value may be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.CustomAudience.Builder setActivationTime(@android.annotation.Nullable java.time.Instant activationTime) { throw new RuntimeException("Stub!"); }

/**
 * Sets the time, truncated to milliseconds, after which the {@link android.adservices.customaudience.CustomAudience CustomAudience} should
 * be removed.
 * <p>
 * See {@link #getExpirationTime()} for more information.
 
 * @param expirationTime This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.CustomAudience.Builder setExpirationTime(@android.annotation.Nullable java.time.Instant expirationTime) { throw new RuntimeException("Stub!"); }

/**
 * Sets the daily update URI. The URI must use HTTPS.
 *
 * <p>See {@link #getDailyUpdateUri()} for more information.
 
 * @param dailyUpdateUri This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.CustomAudience.Builder setDailyUpdateUri(@android.annotation.NonNull android.net.Uri dailyUpdateUri) { throw new RuntimeException("Stub!"); }

/**
 * Sets the user bidding signals used in the ad selection process.
 *
 * <p>See {@link #getUserBiddingSignals()} for more information.
 
 * @param userBiddingSignals This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.CustomAudience.Builder setUserBiddingSignals(@android.annotation.Nullable android.adservices.common.AdSelectionSignals userBiddingSignals) { throw new RuntimeException("Stub!"); }

/**
 * Sets the trusted bidding data to be queried and used in the ad selection process.
 * <p>
 * See {@link #getTrustedBiddingData()} for more information.
 
 * @param trustedBiddingData This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.CustomAudience.Builder setTrustedBiddingData(@android.annotation.Nullable android.adservices.customaudience.TrustedBiddingData trustedBiddingData) { throw new RuntimeException("Stub!"); }

/**
 * Sets the URI to fetch bidding logic from for use in the ad selection process. The URI
 * must use HTTPS.
 *
 * <p>See {@link #getBiddingLogicUri()} for more information.
 
 * @param biddingLogicUri This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.CustomAudience.Builder setBiddingLogicUri(@android.annotation.NonNull android.net.Uri biddingLogicUri) { throw new RuntimeException("Stub!"); }

/**
 * Sets the initial remarketing ads served by the custom audience. Will be assigned with an
 * empty list if not provided.
 *
 * <p>See {@link #getAds()} for more information.
 
 * @param ads This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.CustomAudience.Builder setAds(@android.annotation.Nullable java.util.List<android.adservices.common.AdData> ads) { throw new RuntimeException("Stub!"); }

/**
 * Sets the bitfield of auction server request flags.
 *
 * <p>See {@link #getAuctionServerRequestFlags()} for more information.
 
 * @param auctionServerRequestFlags Value is either <code>0</code> or a combination of android.adservices.customaudience.CustomAudience.FLAG_AUCTION_SERVER_REQUEST_DEFAULT, and {@link android.adservices.customaudience.CustomAudience#FLAG_AUCTION_SERVER_REQUEST_OMIT_ADS}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.CustomAudience.Builder setAuctionServerRequestFlags(int auctionServerRequestFlags) { throw new RuntimeException("Stub!"); }

/**
 * Builds an instance of a {@link android.adservices.customaudience.CustomAudience CustomAudience}.
 *
 * @throws java.lang.NullPointerException     if any non-null parameter is null
 * @throws java.lang.IllegalArgumentException if the expiration time occurs before activation time
 * @throws java.lang.IllegalArgumentException if the expiration time is set before the current time

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.CustomAudience build() { throw new RuntimeException("Stub!"); }
}

}

