/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.topics;


/**
 * Encrypted form of {@link android.adservices.topics.Topic}. This object will be used to return
 * encrypted topic cipher text along with necessary fields required to decrypt it.
 *
 * <p>Decryption of {@link android.adservices.topics.EncryptedTopic#getEncryptedTopic() EncryptedTopic#getEncryptedTopic()} should give json string for {@link android.adservices.topics.Topic Topic}. Example of decrypted json string: {@code { "taxonomy_version": 5, "model_version": 2,
 * "topic_id": 10010 }}
 *
 * <p>Decryption of cipher text is expected to happen on the server with the corresponding algorithm
 * and private key for the public key {@link android.adservices.topics.EncryptedTopic#getKeyIdentifier() EncryptedTopic#getKeyIdentifier()}}.
 *
 * <p>Detailed steps on decryption can be found on <a
 * href="https://developer.android.com/design-for-safety/privacy-sandbox/guides/topics">Developer
 * Guide</a>.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class EncryptedTopic {

/**
 * Creates encrypted version of the {@link android.adservices.topics.Topic Topic} object.
 *
 * @param encryptedTopic byte array cipher text containing encrypted {@link android.adservices.topics.Topic Topic} json string.
 * This value cannot be {@code null}.
 * @param keyIdentifier key used to identify the public key used for encryption.
 * This value cannot be {@code null}.
 * @param encapsulatedKey encapsulated key generated during HPKE setup.

 * This value cannot be {@code null}.
 */

public EncryptedTopic(@android.annotation.NonNull byte[] encryptedTopic, @android.annotation.NonNull java.lang.String keyIdentifier, @android.annotation.NonNull byte[] encapsulatedKey) { throw new RuntimeException("Stub!"); }

/**
 * Returns encrypted bytes for the JSON version of the {@link android.adservices.topics.Topic Topic} object as cipher text.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public byte[] getEncryptedTopic() { throw new RuntimeException("Stub!"); }

/**
 * Returns key identifier for the used encryption key.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getKeyIdentifier() { throw new RuntimeException("Stub!"); }

/**
 * Returns the encapsulated key generated during HPKE setup.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public byte[] getEncapsulatedKey() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object object) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }
}

