/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.customaudience;

import android.adservices.common.AdServicesOutcomeReceiver;
import android.net.Uri;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Executor;

/**
 * The request object wrapping the required and optional parameters to schedule a deferred update
 * for a buyer ad tech's custom audiences.
 *
 * <p>The on-device caller can specify information in a series of {@link android.adservices.customaudience.PartialCustomAudience PartialCustomAudience}
 * objects that will be sent to the buyer ad tech's server after a designated minimum delay.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ScheduleCustomAudienceUpdateRequest {

ScheduleCustomAudienceUpdateRequest() { throw new RuntimeException("Stub!"); }

/**
 * Returns the {@link android.net.Uri Uri} from which the update for the buyer's custom audiences will be
 * fetched.
 *
 * <p>The {@link android.net.Uri Uri} must use the same HTTPS site as the buyer ad tech's enrolled server.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.Uri getUpdateUri() { throw new RuntimeException("Stub!"); }

/**
 * Returns the minimum {@link java.time.Duration Duration} that the update will be deferred before the service
 * fetches updates for the buyer ad tech's custom audiences.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Duration getMinDelay() { throw new RuntimeException("Stub!"); }

/**
 * Returns the list of {@link android.adservices.customaudience.PartialCustomAudience PartialCustomAudience} objects which are sent along with the
 * request to download the updates for the buyer ad tech's custom audiences.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.adservices.customaudience.PartialCustomAudience> getPartialCustomAudienceList() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if any pending scheduled updates should be canceled and replaced with
 * the update detailed in the current {@link android.adservices.customaudience.ScheduleCustomAudienceUpdateRequest ScheduleCustomAudienceUpdateRequest}.
 *
 * <p>If this method returns {@code false} and there are previously requested updates still
 * pending for the same buyer in the same app, a call to {@link android.adservices.customaudience.CustomAudienceManager#scheduleCustomAudienceUpdate(android.adservices.customaudience.ScheduleCustomAudienceUpdateRequest,java.util.concurrent.Executor,android.adservices.common.AdServicesOutcomeReceiver)  } with this {@link android.adservices.customaudience.ScheduleCustomAudienceUpdateRequest ScheduleCustomAudienceUpdateRequest}
 * will fail.
 */

public boolean shouldReplacePendingUpdates() { throw new RuntimeException("Stub!"); }

/** Returns the hash of {@link android.adservices.customaudience.ScheduleCustomAudienceUpdateRequest ScheduleCustomAudienceUpdateRequest} object's data. */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * @return {@code true} only if two {@link android.adservices.customaudience.ScheduleCustomAudienceUpdateRequest ScheduleCustomAudienceUpdateRequest} objects contain
 *     the same information.
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * @return a human-readable representation of {@link android.adservices.customaudience.ScheduleCustomAudienceUpdateRequest ScheduleCustomAudienceUpdateRequest}.
 */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }
/** Builder for {@link android.adservices.customaudience.ScheduleCustomAudienceUpdateRequest ScheduleCustomAudienceUpdateRequest} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Instantiates a builder for a {@link android.adservices.customaudience.ScheduleCustomAudienceUpdateRequest ScheduleCustomAudienceUpdateRequest} object.
 *
 * @param updateUri {@link android.net.Uri Uri} of the buyer ad tech's server from which the updates for the
 *     buyer's custom audiences will be fetched
 * This value cannot be {@code null}.
 * @param minDelay Minimum {@link java.time.Duration Duration} for which the update should be deferred
 * This value cannot be {@code null}.
 * @param partialCustomAudienceList {@link java.util.List List} of {@link android.adservices.customaudience.PartialCustomAudience PartialCustomAudience} objects
 *     which will be sent to the buyer ad tech's server

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.net.Uri updateUri, @android.annotation.NonNull java.time.Duration minDelay, @android.annotation.NonNull java.util.List<android.adservices.customaudience.PartialCustomAudience> partialCustomAudienceList) { throw new RuntimeException("Stub!"); }

/**
 * Sets the {@link android.net.Uri Uri} from which the update for the buyer's custom audiences will be
 * fetched.
 *
 * <p>The {@link android.net.Uri Uri} must use the same HTTPS site as the buyer ad tech's enrolled server.
 *
 * <p>See {@link #getUpdateUri()} for more details.
 
 * @param updateUri This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.ScheduleCustomAudienceUpdateRequest.Builder setUpdateUri(@android.annotation.NonNull android.net.Uri updateUri) { throw new RuntimeException("Stub!"); }

/**
 * Sets the minimum {@link java.time.Duration Duration} that the update will be deferred before the service
 * fetches updates for the buyer ad tech's custom audiences.
 *
 * <p>This delay must not be a negative {@link java.time.Duration Duration}.
 *
 * <p>See {@link #getMinDelay()} for more details.
 
 * @param minDelay This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.ScheduleCustomAudienceUpdateRequest.Builder setMinDelay(@android.annotation.NonNull java.time.Duration minDelay) { throw new RuntimeException("Stub!"); }

/**
 * Sets the list of {@link android.adservices.customaudience.PartialCustomAudience PartialCustomAudience} objects that are sent to the buyer ad
 * tech's server when making a request to download updates for the buyer's custom audiences.
 *
 * <p>See {@link #getPartialCustomAudienceList()} for more details.
 
 * @param partialCustomAudienceList This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.ScheduleCustomAudienceUpdateRequest.Builder setPartialCustomAudienceList(@android.annotation.NonNull java.util.List<android.adservices.customaudience.PartialCustomAudience> partialCustomAudienceList) { throw new RuntimeException("Stub!"); }

/**
 * Sets whether any pending scheduled updates should be deleted and replaced with this
 * {@link android.adservices.customaudience.ScheduleCustomAudienceUpdateRequest ScheduleCustomAudienceUpdateRequest}.
 *
 * <p>By default, this setting is {@code false}.
 *
 * <p>See {@link #shouldReplacePendingUpdates()} for more details.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.ScheduleCustomAudienceUpdateRequest.Builder setShouldReplacePendingUpdates(boolean shouldReplacePendingUpdates) { throw new RuntimeException("Stub!"); }

/**
 * Builds an instance of {@link android.adservices.customaudience.ScheduleCustomAudienceUpdateRequest ScheduleCustomAudienceUpdateRequest}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.ScheduleCustomAudienceUpdateRequest build() { throw new RuntimeException("Stub!"); }
}

}

