/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.adselection;

import android.os.OutcomeReceiver;
import java.util.concurrent.Executor;

/**
 * Contains a per buyer configuration which will be used as part of a {@link android.adservices.adselection.SellerConfiguration SellerConfiguration} in
 * a {@link android.adservices.adselection.GetAdSelectionDataRequest GetAdSelectionDataRequest}.
 *
 * <p>This object will be created by the calling SDK as part of creating the seller configuration.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class PerBuyerConfiguration implements android.os.Parcelable {

PerBuyerConfiguration() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/**
 * Returns the buyer associated with this per buyer configuration.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.AdTechIdentifier getBuyer() { throw new RuntimeException("Stub!"); }

/**
 * The service will make a best effort attempt to include this amount of bytes into the response
 * of {@link android.adservices.adselection.AdSelectionManager#getAdSelectionData(android.adservices.adselection.GetAdSelectionDataRequest,java.util.concurrent.Executor,android.os.OutcomeReceiver) AdSelectionManager#getAdSelectionData(GetAdSelectionDataRequest, Executor,
 * OutcomeReceiver)} for this buyer.
 *
 * <p>If this is zero this buyer will share remaining space after other buyers' target sizes are
 * respected.

 * @return Value is between 0 and Integer.MAX_VALUE inclusive
 */

public int getTargetInputSizeBytes() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.adservices.adselection.PerBuyerConfiguration> CREATOR;
static { CREATOR = null; }
/** Builder for {@link android.adservices.adselection.PerBuyerConfiguration PerBuyerConfiguration} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/** Creates a new {@link android.adservices.adselection.PerBuyerConfiguration.Builder Builder}. */

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Sets the buyer for this configuration. See {@link #getBuyer()} for more details.
 * @param buyer This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.PerBuyerConfiguration.Builder setBuyer(@android.annotation.NonNull android.adservices.common.AdTechIdentifier buyer) { throw new RuntimeException("Stub!"); }

/**
 * Sets the target input size in bytes for this configuration.
 *
 * <p>If this is not explicitly set, this buyer will share remaining space after other
 * buyers' target sizes are respected. See {@link #getTargetInputSizeBytes()} for more
 * details.
 
 * @param targetInputSizeB Value is between 0 and Integer.MAX_VALUE inclusive
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.PerBuyerConfiguration.Builder setTargetInputSizeBytes(int targetInputSizeB) { throw new RuntimeException("Stub!"); }

/**
 * Builds a {@link android.adservices.adselection.PerBuyerConfiguration PerBuyerConfiguration} instance.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.PerBuyerConfiguration build() { throw new RuntimeException("Stub!"); }
}

}

