/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.adselection;

import android.view.InputEvent;

/**
 * Request object wrapping the required arguments needed to report an ad event.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class ReportEventRequest {

ReportEventRequest() { throw new RuntimeException("Stub!"); }

/**
 * Returns the adSelectionId, the primary identifier of an ad selection process.
 */

public long getAdSelectionId() { throw new RuntimeException("Stub!"); }

/**
 * Returns the ad event data.
 *
 * <p>After ad selection, this data is generated by the caller. The caller can then call {@link android.adservices.adselection.AdSelectionManager#reportEvent  }. This data will be attached in a POST request to the {@code
 * reportingUri} registered in {@code registerAdBeacon}.
 *
 * <p>The size of {@link java.lang.String#getBytes() String.getBytes()} in {@code UTF-8} format should be below 64KB.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getData() { throw new RuntimeException("Stub!"); }

/**
 * Returns the input event associated with the user interaction.
 *
 * <p>This field is either {@code null}, representing a <em>view</em> event, or has an {@link android.view.InputEvent InputEvent} object, representing a <em>click</em> event.
 */

@android.annotation.Nullable
public android.view.InputEvent getInputEvent() { throw new RuntimeException("Stub!"); }

/**
 * Returns the event key, the type of ad event to be reported.
 *
 * <p>This field will be used to fetch the {@code reportingUri} associated with the {@code
 * eventKey} registered in {@code registerAdBeacon} after ad selection.
 *
 * <p>This field should be an exact match to the {@code eventKey} registered in {@code
 * registerAdBeacon}. Specific details about {@code registerAdBeacon} can be found at the
 * documentation of {@link android.adservices.adselection.AdSelectionManager#reportImpression AdSelectionManager.reportImpression}
 *
 * <p>The event key (when inspecting its byte array with {@link java.lang.String#getBytes() String.getBytes()}) in {@code
 * UTF-8} format should not exceed 40 bytes. Any key exceeding this limit will not be registered
 * during the {@code registerAdBeacon} call.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getKey() { throw new RuntimeException("Stub!"); }

/**
 * Returns the bitfield of reporting destinations to report to (buyer, seller, component seller
 * or any of the combination of them).
 *
 * <p>To create this bitfield, place an {@code |} bitwise operator between each {@code
 * reportingDestination} to be reported to. For example to only report to buyer, set the
 * reportingDestinations field to {@link #FLAG_REPORTING_DESTINATION_BUYER} To only report to
 * seller, set the reportingDestinations field to {@link #FLAG_REPORTING_DESTINATION_SELLER} To
 * report to buyers and sellers, set the reportingDestinations field to {@link
 * #FLAG_REPORTING_DESTINATION_BUYER} | {@link #FLAG_REPORTING_DESTINATION_SELLER}. To report to
 * buyer, seller and component seller, set the reportingDestinations field to {@link
 * #FLAG_REPORTING_DESTINATION_BUYER} | {@link #FLAG_REPORTING_DESTINATION_SELLER} | {@link
 * #FLAG_REPORTING_DESTINATION_COMPONENT_SELLER}.

 * @return Value is either <code>0</code> or a combination of {@link android.adservices.adselection.ReportEventRequest#FLAG_REPORTING_DESTINATION_SELLER}, {@link android.adservices.adselection.ReportEventRequest#FLAG_REPORTING_DESTINATION_BUYER}, and android.adservices.adselection.ReportEventRequest.FLAG_REPORTING_DESTINATION_COMPONENT_SELLER
 */

public int getReportingDestinations() { throw new RuntimeException("Stub!"); }

/** This is used to represent buyer as the destination for report event API. */

public static final int FLAG_REPORTING_DESTINATION_BUYER = 2; // 0x2

/** This is used to represent seller as the destination for report event API */

public static final int FLAG_REPORTING_DESTINATION_SELLER = 1; // 0x1
/** Builder for {@link android.adservices.adselection.ReportEventRequest ReportEventRequest} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param eventKey This value cannot be {@code null}.
 
 * @param eventData This value cannot be {@code null}.

 * @param reportingDestinations Value is either <code>0</code> or a combination of {@link android.adservices.adselection.ReportEventRequest#FLAG_REPORTING_DESTINATION_SELLER}, {@link android.adservices.adselection.ReportEventRequest#FLAG_REPORTING_DESTINATION_BUYER}, and android.adservices.adselection.ReportEventRequest.FLAG_REPORTING_DESTINATION_COMPONENT_SELLER
 */

public Builder(long adSelectionId, @android.annotation.NonNull java.lang.String eventKey, @android.annotation.NonNull java.lang.String eventData, int reportingDestinations) { throw new RuntimeException("Stub!"); }

/**
 * Builds the {@link android.adservices.adselection.ReportEventRequest ReportEventRequest} object.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.ReportEventRequest build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the ad selection ID with which the rendered ad's events are associated.
 *
 * <p>See {@link #getAdSelectionId()} for more information.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.ReportEventRequest.Builder setAdSelectionId(long adSelectionId) { throw new RuntimeException("Stub!"); }

/**
 * Sets the ad event data.
 *
 * <p>See {@link #getData()} for more information.
 
 * @param eventData This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.ReportEventRequest.Builder setData(@android.annotation.NonNull java.lang.String eventData) { throw new RuntimeException("Stub!"); }

/**
 * Sets the input event associated with the user interaction.
 *
 * <p>See {@link #getInputEvent()} for more information.
 
 * @param inputEvent This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.ReportEventRequest.Builder setInputEvent(@android.annotation.Nullable android.view.InputEvent inputEvent) { throw new RuntimeException("Stub!"); }

/**
 * Sets the event key, the type of ad event to be reported.
 *
 * <p>See {@link #getKey()} for more information.
 
 * @param eventKey This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.ReportEventRequest.Builder setKey(@android.annotation.NonNull java.lang.String eventKey) { throw new RuntimeException("Stub!"); }

/**
 * Sets the bitfield of reporting destinations to report to (buyer, seller, or both).
 *
 * <p>See {@link #getReportingDestinations()} for more information.
 
 * @param reportingDestinations Value is either <code>0</code> or a combination of {@link android.adservices.adselection.ReportEventRequest#FLAG_REPORTING_DESTINATION_SELLER}, {@link android.adservices.adselection.ReportEventRequest#FLAG_REPORTING_DESTINATION_BUYER}, and android.adservices.adselection.ReportEventRequest.FLAG_REPORTING_DESTINATION_COMPONENT_SELLER
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.ReportEventRequest.Builder setReportingDestinations(int reportingDestinations) { throw new RuntimeException("Stub!"); }
}

}

