/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.adservices.adselection;

import android.adservices.common.AdSelectionSignals;
import android.adservices.common.AdTechIdentifier;
import android.net.Uri;
import java.util.Map;

/**
 * Contains the configuration of the ad selection process.
 *
 * <p>Instances of this class are created by SDKs to be provided as arguments to the {@link android.adservices.adselection.AdSelectionManager#selectAds  } and {@link android.adservices.adselection.AdSelectionManager#reportImpression AdSelectionManager.reportImpression} methods in {@link android.adservices.adselection.AdSelectionManager AdSelectionManager}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class AdSelectionConfig implements android.os.Parcelable {

AdSelectionConfig() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * @return JSON in an AdSelectionSignals object, fetched from the AdSelectionConfig and consumed
 *     by the JS logic fetched from the DSP, represents signals given to the participating
 *     buyers in the ad selection and reporting processes.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.AdSelectionSignals getAdSelectionSignals() { throw new RuntimeException("Stub!"); }

/**
 * @return a list of custom audience buyers allowed by the SSP to participate in the ad
 *     selection process

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.adservices.common.AdTechIdentifier> getCustomAudienceBuyers() { throw new RuntimeException("Stub!"); }

/**
 * @return the URI used to retrieve the JS code containing the seller/SSP scoreAd function used
 *     during the ad selection and reporting processes

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.Uri getDecisionLogicUri() { throw new RuntimeException("Stub!"); }

/**
 * @return a Map of buyers and AdSelectionSignals, fetched from the AdSelectionConfig and
 *     consumed by the JS logic fetched from the DSP, representing any information that each
 *     buyer would provide during ad selection to participants (such as bid floor, ad selection
 *     type, etc.)

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Map<android.adservices.common.AdTechIdentifier,android.adservices.common.AdSelectionSignals> getPerBuyerSignals() { throw new RuntimeException("Stub!"); }

/**
 * @return a Map of buyers and corresponding Contextual Ads, these ads are expected to be
 *     pre-downloaded from the contextual path and injected into Ad Selection.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Map<android.adservices.common.AdTechIdentifier,android.adservices.adselection.SignedContextualAds> getPerBuyerSignedContextualAds() { throw new RuntimeException("Stub!"); }

/**
 * @return a AdTechIdentifier of the seller, for example "www.example-ssp.com"
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.AdTechIdentifier getSeller() { throw new RuntimeException("Stub!"); }

/**
 * @return JSON in an AdSelectionSignals object, provided by the SSP and consumed by the JS
 *     logic fetched from the SSP, represents any information that the SSP used in the ad
 *     scoring process to tweak the results of the ad selection process (e.g.&nbsp;brand safety
 *     checks, excluded contextual ads).

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.AdSelectionSignals getSellerSignals() { throw new RuntimeException("Stub!"); }

/**
 * @return URI endpoint of sell-side trusted signal from which creative specific realtime
 *     information can be fetched from.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.Uri getTrustedScoringSignalsUri() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.adservices.adselection.AdSelectionConfig> CREATOR;
static { CREATOR = null; }
/** Builder for {@link android.adservices.adselection.AdSelectionConfig AdSelectionConfig} object. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Builds an {@link android.adservices.adselection.AdSelectionConfig AdSelectionConfig} instance.
 *
 * @throws java.lang.NullPointerException if any required params are null

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.AdSelectionConfig build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the signals provided to buyers during ad selection bid generation.
 *
 * <p>If not set, defaults to the empty JSON.
 *
 * <p>See {@link #getAdSelectionSignals()} for more details.
 
 * @param adSelectionSignals This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.AdSelectionConfig.Builder setAdSelectionSignals(@android.annotation.NonNull android.adservices.common.AdSelectionSignals adSelectionSignals) { throw new RuntimeException("Stub!"); }

/**
 * Sets the list of allowed buyers.
 *
 * <p>See {@link #getCustomAudienceBuyers()} for more details.
 
 * @param customAudienceBuyers This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.AdSelectionConfig.Builder setCustomAudienceBuyers(@android.annotation.NonNull java.util.List<android.adservices.common.AdTechIdentifier> customAudienceBuyers) { throw new RuntimeException("Stub!"); }

/**
 * Sets the URI used to fetch decision logic for use in the ad selection process. Decision
 * URI could be either of the two schemas:
 *
 * <ul>
 *   <li><b>HTTPS:</b> HTTPS URIs have to be absolute URIs where the host matches the {@code
 *       seller}
 *   <li><b>Ad Selection Prebuilt:</b> Ad Selection Service URIs follow {@code
 *       ad-selection-prebuilt://ad-selection/<name>?<script-generation-parameters>} format.
 *       FLEDGE generates the appropriate JS script without the need for a network call.
 *       <p>Available prebuilt scripts:
 *       <ul>
 *         <li><b>{@code highest-bid-wins} for {@code scoreAds} and {@code
 *             reportResult}:</b> This JS picks the ad with the highest bid for scoring. For
 *             reporting, the given URI is parameterized with {@code render_uri} and {@code
 *             bid}. Below parameter(s) are required to use this prebuilt:
 *             <ul>
 *               <li><b>{@code reportingUrl}:</b> Base reporting uri that will be
 *                   parameterized later with {@code render_uri} and {@code bid}
 *             </ul>
 *             <p>Ex. If your base reporting URL is "https://www.ssp.com" then, {@code
 *             ad-selection-prebuilt://ad-selection/highest-bid-wins/?reportingUrl=https://www.ssp.com}
 *       </ul>
 * </ul>
 *
 * <p>See {@link #getDecisionLogicUri()} for more details.
 
 * @param decisionLogicUri This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.AdSelectionConfig.Builder setDecisionLogicUri(@android.annotation.NonNull android.net.Uri decisionLogicUri) { throw new RuntimeException("Stub!"); }

/**
 * Sets the signals provided by each buyer during ad selection.
 *
 * <p>If not set, defaults to an empty map.
 *
 * <p>See {@link #getPerBuyerSignals()} for more details.
 
 * @param perBuyerSignals This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.AdSelectionConfig.Builder setPerBuyerSignals(@android.annotation.NonNull java.util.Map<android.adservices.common.AdTechIdentifier,android.adservices.common.AdSelectionSignals> perBuyerSignals) { throw new RuntimeException("Stub!"); }

/**
 * Sets the contextual Ads corresponding to each buyer during ad selection.
 *
 * <p>If not set, defaults to an empty map.
 *
 * <p>See {@link #getPerBuyerSignedContextualAds()} for more details.
 
 * @param buyerSignedContextualAds This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.AdSelectionConfig.Builder setPerBuyerSignedContextualAds(@android.annotation.NonNull java.util.Map<android.adservices.common.AdTechIdentifier,android.adservices.adselection.SignedContextualAds> buyerSignedContextualAds) { throw new RuntimeException("Stub!"); }

/**
 * Sets the seller identifier.
 *
 * <p>See {@link #getSeller()} for more details.
 
 * @param seller This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.AdSelectionConfig.Builder setSeller(@android.annotation.NonNull android.adservices.common.AdTechIdentifier seller) { throw new RuntimeException("Stub!"); }

/**
 * Set the signals used to modify ad selection results.
 *
 * <p>If not set, defaults to the empty JSON.
 *
 * <p>See {@link #getSellerSignals()} for more details.
 
 * @param sellerSignals This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.AdSelectionConfig.Builder setSellerSignals(@android.annotation.NonNull android.adservices.common.AdSelectionSignals sellerSignals) { throw new RuntimeException("Stub!"); }

/**
 * Sets the URI endpoint of sell-side trusted signal from which creative specific realtime
 * information can be fetched from.
 *
 * <p>If {@link android.net.Uri#EMPTY Uri.EMPTY} is passed then network call will be skipped and {@link android.adservices.common.AdSelectionSignals#EMPTY  } will be passed to ad selection.
 *
 * <p>See {@link #getTrustedScoringSignalsUri()} for more details.
 
 * @param trustedScoringSignalsUri This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.AdSelectionConfig.Builder setTrustedScoringSignalsUri(@android.annotation.NonNull android.net.Uri trustedScoringSignalsUri) { throw new RuntimeException("Stub!"); }
}

}

