/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.adselection;

import android.os.OutcomeReceiver;
import java.util.concurrent.Executor;

/**
 * This object will be part of the {@link android.adservices.adselection.GetAdSelectionDataRequest GetAdSelectionDataRequest} and will be constructed and
 * used by the SDK to influence the size of the response of {@link android.adservices.adselection.AdSelectionManager#getAdSelectionData(android.adservices.adselection.GetAdSelectionDataRequest,java.util.concurrent.Executor,android.os.OutcomeReceiver)  }
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SellerConfiguration implements android.os.Parcelable {

SellerConfiguration() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the maximum size of the payload in bytes that the service will return.
 * @return Value is between 1 and Integer.MAX_VALUE inclusive
 */

public int getMaximumPayloadSizeBytes() { throw new RuntimeException("Stub!"); }

/**
 * Returns a set of per buyer configurations that the service will do a best effort to respect
 * when constructing the response without exceeding {@link #getMaximumPayloadSizeBytes()}.
 *
 * <p>If this is empty, the service will fill up the response with buyer data until {@link
 * #getMaximumPayloadSizeBytes()} is reached. Otherwise, only data from buyers from the per
 * buyer configuration will be included. If the sum of {@link android.adservices.adselection.PerBuyerConfiguration#getTargetInputSizeBytes()  } sizes is larger than {@link
 * #getMaximumPayloadSizeBytes()}, the service will do a best effort attempt to proportionally
 * include the buyer data based on the ratio between that specific buyer's target and the sum of
 * {@link android.adservices.adselection.PerBuyerConfiguration#getTargetInputSizeBytes() PerBuyerConfiguration.getTargetInputSizeBytes()}.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<android.adservices.adselection.PerBuyerConfiguration> getPerBuyerConfigurations() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.adservices.adselection.SellerConfiguration> CREATOR;
static { CREATOR = null; }
/** Builder for {@link android.adservices.adselection.SellerConfiguration SellerConfiguration} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Builds a {@link android.adservices.adselection.SellerConfiguration SellerConfiguration} instance.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.SellerConfiguration build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the target payload size in bytes. For more information see {@link
 * #getMaximumPayloadSizeBytes()}
 
 * @param maximumPayloadSizeBytes Value is between 1 and Integer.MAX_VALUE inclusive
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.SellerConfiguration.Builder setMaximumPayloadSizeBytes(int maximumPayloadSizeBytes) { throw new RuntimeException("Stub!"); }

/**
 * Sets the per buyer configurations. For more information see {@link
 * #getPerBuyerConfigurations()}
 
 * @param perBuyerConfigurations This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.SellerConfiguration.Builder setPerBuyerConfigurations(@android.annotation.NonNull java.util.Set<android.adservices.adselection.PerBuyerConfiguration> perBuyerConfigurations) { throw new RuntimeException("Stub!"); }
}

}

