/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.sdksandbox;

import android.content.pm.SharedLibraryInfo;
import android.os.IBinder;

/**
 * Represents an SDK loaded in the sandbox process.
 *
 * <p>Returned in response to {@link android.app.sdksandbox.SdkSandboxManager#loadSdk SdkSandboxManager.loadSdk}, on success. An application can
 * obtain it by calling {@link android.app.sdksandbox.SdkSandboxManager#loadSdk SdkSandboxManager.loadSdk}. It should use this object to obtain an
 * interface to the SDK through {@link #getInterface()}.
 *
 * <p>The SDK should create it when {@link android.app.sdksandbox.SandboxedSdkProvider#onLoadSdk SandboxedSdkProvider.onLoadSdk} is called, and drop all
 * references to it when {@link android.app.sdksandbox.SandboxedSdkProvider#beforeUnloadSdk() SandboxedSdkProvider.beforeUnloadSdk()} is called. Additionally, the
 * SDK should fail calls made to the {@code IBinder} returned from {@link #getInterface()} after
 * {@link android.app.sdksandbox.SandboxedSdkProvider#beforeUnloadSdk() SandboxedSdkProvider.beforeUnloadSdk()} has been called.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SandboxedSdk implements android.os.Parcelable {

/**
 * Creates a {@link android.app.sdksandbox.SandboxedSdk SandboxedSdk} object.
 *
 * @param sdkInterface The SDK's interface. This will be the entrypoint into the sandboxed SDK
 *     for the application. The SDK should keep this valid until it's loaded in the sandbox, and
 *     start failing calls to this interface once it has been unloaded.
 *     <p>This interface can later be retrieved using {@link #getInterface()}.

 * This value cannot be {@code null}.
 */

public SandboxedSdk(@android.annotation.NonNull android.os.IBinder sdkInterface) { throw new RuntimeException("Stub!"); }

/** {@inheritDoc} */

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Returns the interface to the SDK that was loaded in response to {@link android.app.sdksandbox.SdkSandboxManager#loadSdk  }. A {@code null} interface is returned if the Binder has since
 * become unavailable, in response to the SDK being unloaded.
 */

@android.annotation.Nullable
public android.os.IBinder getInterface() { throw new RuntimeException("Stub!"); }

/**
 * Returns the {@link android.content.pm.SharedLibraryInfo SharedLibraryInfo} for the SDK.
 *
 * @throws java.lang.IllegalStateException if the system service has not yet attached {@link android.content.pm.SharedLibraryInfo SharedLibraryInfo} to the {@link android.app.sdksandbox.SandboxedSdk SandboxedSdk} object sent by the SDK.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.content.pm.SharedLibraryInfo getSharedLibraryInfo() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.app.sdksandbox.SandboxedSdk> CREATOR;
static { CREATOR = null; }
}

