/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.customaudience;


/**
 * The request object to join a custom audience.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class JoinCustomAudienceRequest {

private JoinCustomAudienceRequest() { throw new RuntimeException("Stub!"); }

/**
 * Returns the custom audience to join.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.CustomAudience getCustomAudience() { throw new RuntimeException("Stub!"); }

/**
 * Checks whether two {@link android.adservices.customaudience.JoinCustomAudienceRequest JoinCustomAudienceRequest} objects contain the same information.
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the hash of the {@link android.adservices.customaudience.JoinCustomAudienceRequest JoinCustomAudienceRequest} object's data.
 */

public int hashCode() { throw new RuntimeException("Stub!"); }
/** Builder for {@link android.adservices.customaudience.JoinCustomAudienceRequest JoinCustomAudienceRequest} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Sets the custom audience to join.
 * <p>
 * See {@link #getCustomAudience()} ()} for more information.
 
 * @param customAudience This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.JoinCustomAudienceRequest.Builder setCustomAudience(@android.annotation.NonNull android.adservices.customaudience.CustomAudience customAudience) { throw new RuntimeException("Stub!"); }

/**
 * Builds an instance of a {@link android.adservices.customaudience.JoinCustomAudienceRequest JoinCustomAudienceRequest}.
 *
 * @throws java.lang.NullPointerException if any non-null parameter is null

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.JoinCustomAudienceRequest build() { throw new RuntimeException("Stub!"); }
}

}

