/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.customaudience;

import android.adservices.common.AdTechIdentifier;

/** The request object is used to leave a custom audience. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class LeaveCustomAudienceRequest {

private LeaveCustomAudienceRequest() { throw new RuntimeException("Stub!"); }

/**
 * Gets the buyer's {@link android.adservices.common.AdTechIdentifier AdTechIdentifier}, as identified by a domain in the form
 * "buyerexample.com".
 *
 * @return an {@link android.adservices.common.AdTechIdentifier AdTechIdentifier} containing the custom audience's buyer's domain

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.AdTechIdentifier getBuyer() { throw new RuntimeException("Stub!"); }

/**
 * Gets the arbitrary string provided by the owner and buyer on creation of the {@link android.adservices.customaudience.CustomAudience CustomAudience} object that represents a single custom audience.
 *
 * @return the String name of the custom audience

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getName() { throw new RuntimeException("Stub!"); }

/**
 * Checks whether two {@link android.adservices.customaudience.LeaveCustomAudienceRequest LeaveCustomAudienceRequest} objects contain the same information.
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the hash of the {@link android.adservices.customaudience.LeaveCustomAudienceRequest LeaveCustomAudienceRequest} object's data.
 */

public int hashCode() { throw new RuntimeException("Stub!"); }
/** Builder for {@link android.adservices.customaudience.LeaveCustomAudienceRequest LeaveCustomAudienceRequest} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Sets the buyer {@link android.adservices.common.AdTechIdentifier AdTechIdentifier}.
 *
 * <p>See {@link #getBuyer()} for more information.
 
 * @param buyer This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.LeaveCustomAudienceRequest.Builder setBuyer(@android.annotation.NonNull android.adservices.common.AdTechIdentifier buyer) { throw new RuntimeException("Stub!"); }

/**
 * Sets the {@link android.adservices.customaudience.CustomAudience CustomAudience} object's name.
 * <p>
 * See {@link #getName()} for more information.
 
 * @param name This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.LeaveCustomAudienceRequest.Builder setName(@android.annotation.NonNull java.lang.String name) { throw new RuntimeException("Stub!"); }

/**
 * Builds an instance of a {@link android.adservices.customaudience.LeaveCustomAudienceRequest LeaveCustomAudienceRequest}.
 *
 * @throws java.lang.NullPointerException if any non-null parameter is null

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.LeaveCustomAudienceRequest build() { throw new RuntimeException("Stub!"); }
}

}

