/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.measurement;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class DeletionRequest {

private DeletionRequest() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.net.Uri> getOriginUris() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.net.Uri> getDomainUris() { throw new RuntimeException("Stub!"); }

public int getDeletionMode() { throw new RuntimeException("Stub!"); }

public int getMatchBehavior() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.time.Instant getStart() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.time.Instant getEnd() { throw new RuntimeException("Stub!"); }

public static final int DELETION_MODE_ALL = 0; // 0x0

public static final int DELETION_MODE_EXCLUDE_INTERNAL_DATA = 1; // 0x1

public static final int MATCH_BEHAVIOR_DELETE = 0; // 0x0

public static final int MATCH_BEHAVIOR_PRESERVE = 1; // 0x1
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.adservices.measurement.DeletionRequest.Builder setOriginUris(@android.annotation.Nullable java.util.List<android.net.Uri> originUris) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.adservices.measurement.DeletionRequest.Builder setDomainUris(@android.annotation.Nullable java.util.List<android.net.Uri> domainUris) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.adservices.measurement.DeletionRequest.Builder setMatchBehavior(int matchBehavior) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.adservices.measurement.DeletionRequest.Builder setDeletionMode(int deletionMode) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.adservices.measurement.DeletionRequest.Builder setStart(@android.annotation.NonNull java.time.Instant start) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.adservices.measurement.DeletionRequest.Builder setEnd(@android.annotation.NonNull java.time.Instant end) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.adservices.measurement.DeletionRequest build() { throw new RuntimeException("Stub!"); }
}

}

