/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.common;


/** An Identifier representing an ad buyer or seller. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class AdTechIdentifier implements android.os.Parcelable {

private AdTechIdentifier() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/**
 * Compares this AdTechIdentifier to the specified object. The result is true if and only if the
 * argument is not null and is a AdTechIdentifier object with the same string form (obtained by
 * calling {@link #toString()}). Note that this method will not perform any eTLD+1 normalization
 * so two AdTechIdentifier objects with the same eTLD+1 could be not equal if the String
 * representations of the objects was not equal.
 *
 * @param o The object to compare this AdTechIdentifier against
 * @return true if the given object represents an AdTechIdentifier equivalent to this
 *     AdTechIdentifier, false otherwise
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns a hash code corresponding to the string representation of this class obtained by
 * calling {@link #toString()}. Note that this method will not perform any eTLD+1 normalization
 * so two AdTechIdentifier objects with the same eTLD+1 could have different hash codes if the
 * underlying string representation was different.
 *
 * @return a hash code value for this object.
 */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * @return The identifier in String form.
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * Construct an instance of this class from a String.
 *
 * @param source A valid eTLD+1 domain of an ad buyer or seller or null.
 * @return An {@link android.adservices.common.AdTechIdentifier AdTechIdentifier} class wrapping the given domain or null if the input was
 *     null.
 */

@android.annotation.NonNull
public static android.adservices.common.AdTechIdentifier fromString(@android.annotation.NonNull java.lang.String source) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.adservices.common.AdTechIdentifier> CREATOR;
static { CREATOR = null; }
}

