/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.measurement;

import android.net.Uri;
import android.view.InputEvent;

/** Class to hold input to measurement source registration calls from web context. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class WebSourceRegistrationRequest implements android.os.Parcelable {

private WebSourceRegistrationRequest() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Getter for source params.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.adservices.measurement.WebSourceParams> getSourceParams() { throw new RuntimeException("Stub!"); }

/**
 * Getter for top origin Uri.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.Uri getTopOriginUri() { throw new RuntimeException("Stub!"); }

/**
 * Getter for input event.
 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public android.view.InputEvent getInputEvent() { throw new RuntimeException("Stub!"); }

/**
 * Getter for the app destination. It is the android app {@link android.net.Uri Uri} where corresponding
 * conversion is expected. At least one of app destination or web destination is required.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public android.net.Uri getAppDestination() { throw new RuntimeException("Stub!"); }

/**
 * Getter for web destination. It is the website {@link android.net.Uri Uri} where corresponding conversion is
 * expected. At least one of app destination or web destination is required.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public android.net.Uri getWebDestination() { throw new RuntimeException("Stub!"); }

/**
 * Getter for verified destination.
 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public android.net.Uri getVerifiedDestination() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param out This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel out, int flags) { throw new RuntimeException("Stub!"); }

/** Creator for Paracelable (via reflection). */

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.adservices.measurement.WebSourceRegistrationRequest> CREATOR;
static { CREATOR = null; }
/** Builder for {@link android.adservices.measurement.WebSourceRegistrationRequest WebSourceRegistrationRequest}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Builder constructor for {@link android.adservices.measurement.WebSourceRegistrationRequest WebSourceRegistrationRequest}.
 *
 * @param webSourceParams source parameters containing source registration parameters, the
 *     list should not be empty
 * This value cannot be {@code null}.
 * @param topOriginUri source publisher {@link android.net.Uri Uri}

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull java.util.List<android.adservices.measurement.WebSourceParams> webSourceParams, @android.annotation.NonNull android.net.Uri topOriginUri) { throw new RuntimeException("Stub!"); }

/**
 * Setter for input event.
 *
 * @param inputEvent User Interaction InputEvent used by the AttributionReporting API to
 *     distinguish clicks from views.
 * This value may be {@code null}.
 * @return builder
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.measurement.WebSourceRegistrationRequest.Builder setInputEvent(@android.annotation.Nullable android.view.InputEvent inputEvent) { throw new RuntimeException("Stub!"); }

/**
 * Setter for app destination. It is the android app {@link android.net.Uri Uri} where corresponding
 * conversion is expected. At least one of app destination or web destination is required.
 *
 * @param appDestination app destination {@link android.net.Uri Uri}
 * This value may be {@code null}.
 * @return builder
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.measurement.WebSourceRegistrationRequest.Builder setAppDestination(@android.annotation.Nullable android.net.Uri appDestination) { throw new RuntimeException("Stub!"); }

/**
 * Setter for web destination. It is the website {@link android.net.Uri Uri} where corresponding conversion
 * is expected. At least one of app destination or web destination is required.
 *
 * @param webDestination web destination {@link android.net.Uri Uri}
 * This value may be {@code null}.
 * @return builder
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.measurement.WebSourceRegistrationRequest.Builder setWebDestination(@android.annotation.Nullable android.net.Uri webDestination) { throw new RuntimeException("Stub!"); }

/**
 * Setter for verified destination.
 *
 * @param verifiedDestination verified destination
 * This value may be {@code null}.
 * @return builder
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.measurement.WebSourceRegistrationRequest.Builder setVerifiedDestination(@android.annotation.Nullable android.net.Uri verifiedDestination) { throw new RuntimeException("Stub!"); }

/**
 * Pre-validates parameters and builds {@link android.adservices.measurement.WebSourceRegistrationRequest WebSourceRegistrationRequest}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.measurement.WebSourceRegistrationRequest build() { throw new RuntimeException("Stub!"); }
}

}

