/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.app.sdksandbox.sdkprovider;

import android.content.Context;
import android.app.sdksandbox.SandboxedSdkProvider;
import android.app.sdksandbox.SandboxedSdk;
import java.util.List;
import android.app.sdksandbox.SdkSandboxManager;
import android.content.SharedPreferences;

/**
 * Controller that is used by SDK loaded in the sandbox to access information provided by the sdk
 * sandbox.
 *
 * <p>It enables the SDK to communicate with other SDKS in the SDK sandbox and know about the state
 * of the sdks that are currently loaded in it.
 *
 * <p>An instance of {@link android.app.sdksandbox.sdkprovider.SdkSandboxController SdkSandboxController} can be obtained using {@link android.content.Context#getSystemService  } and {@link android.app.sdksandbox.sdkprovider.SdkSandboxController class}. The {@link android.content.Context Context} can in turn
 * be obtained using {@link android.app.sdksandbox.SandboxedSdkProvider#getContext()}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class SdkSandboxController {

SdkSandboxController() { throw new RuntimeException("Stub!"); }

/**
 * Fetches information about Sdks that are loaded in the sandbox.
 *
 * @return List of {@link android.app.sdksandbox.SandboxedSdk SandboxedSdk} containing all currently loaded sdks
 * This value cannot be {@code null}.
 * @throws java.lang.UnsupportedOperationException if the controller is obtained from an unexpected
 *     context. Use {@link android.app.sdksandbox.SandboxedSdkProvider#getContext() SandboxedSdkProvider#getContext()} for the right context
 */

@android.annotation.NonNull
public java.util.List<android.app.sdksandbox.SandboxedSdk> getSandboxedSdks() { throw new RuntimeException("Stub!"); }

/**
 * Returns {@link android.content.SharedPreferences SharedPreferences} containing data synced from the client app.
 *
 * <p>Keys that have been synced by the client app using {@link android.app.sdksandbox.SdkSandboxManager#addSyncedSharedPreferencesKeys(Set)  } can be found in this {@link android.content.SharedPreferences SharedPreferences}.
 *
 * <p>The returned {@link android.content.SharedPreferences SharedPreferences} should only be read. Writing to it is not
 * supported.
 *
 * @return {@link android.content.SharedPreferences SharedPreferences} containing data synced from client app.
 * This value cannot be {@code null}.
 * @throws java.lang.UnsupportedOperationException if the controller is obtained from an unexpected
 *     context. Use {@link android.app.sdksandbox.SandboxedSdkProvider#getContext() SandboxedSdkProvider#getContext()} for the right context
 */

@android.annotation.NonNull
public android.content.SharedPreferences getClientSharedPreferences() { throw new RuntimeException("Stub!"); }

public static final java.lang.String SDK_SANDBOX_CONTROLLER_SERVICE = "sdk_sandbox_controller_service";
}

