/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package com.android.server.sdksandbox;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface SdkSandboxManagerLocal {

public void enforceAllowedToSendBroadcast(@android.annotation.NonNull android.content.Intent intent);

public void enforceAllowedToStartActivity(@android.annotation.NonNull android.content.Intent intent);

public void enforceAllowedToStartOrBindService(@android.annotation.NonNull android.content.Intent intent);

@android.annotation.NonNull
public java.lang.String getSdkSandboxProcessNameForInstrumentation(@android.annotation.NonNull android.content.pm.ApplicationInfo clientAppInfo);

public void notifyInstrumentationStarted(@android.annotation.NonNull java.lang.String clientAppPackageName, int clientAppUid);

public void notifyInstrumentationFinished(@android.annotation.NonNull java.lang.String clientAppPackageName, int clientAppUid);

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.SERVICE_ACTION) public static final java.lang.String SERVICE_INTERFACE = "com.android.sdksandbox.SdkSandboxService";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String VERIFIER_RECEIVER = "com.android.server.sdksandbox.SdkSandboxVerifierReceiver";
}

