/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.measurement;

import java.time.Instant;

/** Deletion Request. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class DeletionRequest {

DeletionRequest() { throw new RuntimeException("Stub!"); }

/**
 * Get the list of origin URIs.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.net.Uri> getOriginUris() { throw new RuntimeException("Stub!"); }

/**
 * Get the list of domain URIs.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.net.Uri> getDomainUris() { throw new RuntimeException("Stub!"); }

/**
 * Get the deletion mode.
 * @return Value is {@link android.adservices.measurement.DeletionRequest#DELETION_MODE_ALL}, or {@link android.adservices.measurement.DeletionRequest#DELETION_MODE_EXCLUDE_INTERNAL_DATA}
 */

public int getDeletionMode() { throw new RuntimeException("Stub!"); }

/**
 * Get the match behavior.
 * @return Value is {@link android.adservices.measurement.DeletionRequest#MATCH_BEHAVIOR_DELETE}, or {@link android.adservices.measurement.DeletionRequest#MATCH_BEHAVIOR_PRESERVE}
 */

public int getMatchBehavior() { throw new RuntimeException("Stub!"); }

/**
 * Get the start of the deletion range.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Instant getStart() { throw new RuntimeException("Stub!"); }

/**
 * Get the end of the deletion range.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Instant getEnd() { throw new RuntimeException("Stub!"); }

/** Deletion mode to delete all data associated with the selected records. */

public static final int DELETION_MODE_ALL = 0; // 0x0

/**
 * Deletion mode to delete all data except the internal data (e.g.&nbsp;rate limits) for the selected
 * records.
 */

public static final int DELETION_MODE_EXCLUDE_INTERNAL_DATA = 1; // 0x1

/** Match behavior option to delete the supplied params (Origin/Domains). */

public static final int MATCH_BEHAVIOR_DELETE = 0; // 0x0

/**
 * Match behavior option to preserve the supplied params (Origin/Domains) and delete everything
 * else.
 */

public static final int MATCH_BEHAVIOR_PRESERVE = 1; // 0x1
/** Builder for {@link android.adservices.measurement.DeletionRequest DeletionRequest} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Set the list of origin URI which will be used for matching. These will be matched with
 * records using the same origin only, i.e. subdomains won't match. E.g. If originUri is
 * {@code https://a.example.com}, then {@code https://a.example.com} will match; {@code
 * https://example.com}, {@code https://b.example.com} and {@code https://abcexample.com}
 * will NOT match. A null or empty list will match everything.

 * @param originUris This value may be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.measurement.DeletionRequest.Builder setOriginUris(@android.annotation.Nullable java.util.List<android.net.Uri> originUris) { throw new RuntimeException("Stub!"); }

/**
 * Set the list of domain URI which will be used for matching. These will be matched with
 * records using the same domain or any subdomains. E.g. If domainUri is {@code
 * https://example.com}, then {@code https://a.example.com}, {@code https://example.com} and
 * {@code https://b.example.com} will match; {@code https://abcexample.com} will NOT match.
 * A null or empty list will match everything.

 * @param domainUris This value may be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.measurement.DeletionRequest.Builder setDomainUris(@android.annotation.Nullable java.util.List<android.net.Uri> domainUris) { throw new RuntimeException("Stub!"); }

/**
 * Set the match behavior for the supplied params. {@link #MATCH_BEHAVIOR_DELETE}: This
 * option will use the supplied params (Origin URIs & Domain URIs) for selecting records for
 * deletion. {@link #MATCH_BEHAVIOR_PRESERVE}: This option will preserve the data associated
 * with the supplied params (Origin URIs & Domain URIs) and select remaining records for
 * deletion.
 
 * @param matchBehavior Value is {@link android.adservices.measurement.DeletionRequest#MATCH_BEHAVIOR_DELETE}, or {@link android.adservices.measurement.DeletionRequest#MATCH_BEHAVIOR_PRESERVE}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.measurement.DeletionRequest.Builder setMatchBehavior(int matchBehavior) { throw new RuntimeException("Stub!"); }

/**
 * Set the match behavior for the supplied params. {@link #DELETION_MODE_ALL}: All data
 * associated with the selected records will be deleted. {@link
 * #DELETION_MODE_EXCLUDE_INTERNAL_DATA}: All data except the internal system data (e.g.
 * rate limits) associated with the selected records will be deleted.
 
 * @param deletionMode Value is {@link android.adservices.measurement.DeletionRequest#DELETION_MODE_ALL}, or {@link android.adservices.measurement.DeletionRequest#DELETION_MODE_EXCLUDE_INTERNAL_DATA}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.measurement.DeletionRequest.Builder setDeletionMode(int deletionMode) { throw new RuntimeException("Stub!"); }

/**
 * Set the start of the deletion range. Passing in {@link java.time.Instant#MIN} will cause
 * everything from the oldest record to the specified end be deleted. No set start will
 * default to {@link java.time.Instant#MIN}.
 
 * @param start This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.measurement.DeletionRequest.Builder setStart(@android.annotation.NonNull java.time.Instant start) { throw new RuntimeException("Stub!"); }

/**
 * Set the end of the deletion range. Passing in {@link java.time.Instant#MAX} will cause
 * everything from the specified start until the newest record to be deleted. No set end
 * will default to {@link java.time.Instant#MAX}.
 
 * @param end This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.measurement.DeletionRequest.Builder setEnd(@android.annotation.NonNull java.time.Instant end) { throw new RuntimeException("Stub!"); }

/**
 * Builds a {@link android.adservices.measurement.DeletionRequest DeletionRequest} instance.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.measurement.DeletionRequest build() { throw new RuntimeException("Stub!"); }
}

}

