/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.adservices.topics;


/** Represent the topic result from the getTopics API. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class Topic {

/**
 * Creates an object which represents the result from the getTopics API.
 *
 * @param mTaxonomyVersion a long representing the version of the taxonomy.
 * @param mModelVersion a long representing the version of the model.
 * @param mTopicId an integer representing the unique id of a topic.
 */

public Topic(long mTaxonomyVersion, long mModelVersion, int mTopicId) { throw new RuntimeException("Stub!"); }

/** Get the ModelVersion. */

public long getModelVersion() { throw new RuntimeException("Stub!"); }

/** Get the TaxonomyVersion. */

public long getTaxonomyVersion() { throw new RuntimeException("Stub!"); }

/** Get the Topic ID. */

public int getTopicId() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object object) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }
}

