/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.adselection;

import android.adservices.common.FrequencyCapFilters;
import java.util.concurrent.Executor;
import android.os.OutcomeReceiver;
import android.adservices.common.AdTechIdentifier;

/**
 * Request object wrapping the required arguments needed to update an ad counter histogram.
 *
 * <p>The ad counter histograms, which are historical logs of events which are associated with an ad
 * counter key and an ad event type, are used to inform frequency cap filtering when using the
 * Protected Audience APIs.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class UpdateAdCounterHistogramRequest {

UpdateAdCounterHistogramRequest() { throw new RuntimeException("Stub!"); }

/**
 * Gets the ad selection ID with which the rendered ad's events are associated.
 *
 * <p>For more information about the ad selection ID, see {@link android.adservices.adselection.AdSelectionOutcome AdSelectionOutcome}.
 *
 * <p>The ad must have been selected from Protected Audience ad selection in the last 24 hours,
 * and the ad selection call must have been initiated from the same app as the current calling
 * app. Event histograms for all ad counter keys associated with the ad specified by the ad
 * selection ID will be updated for the ad event type from {@link #getAdEventType()}, to be used
 * in Protected Audience frequency cap filtering.
 */

public long getAdSelectionId() { throw new RuntimeException("Stub!"); }

/**
 * Gets the ad event type which, along with an ad's counter keys, identifies which histogram
 * should be updated.

 * @return Value is android.adservices.common.FrequencyCapFilters.AD_EVENT_TYPE_INVALID, {@link android.adservices.common.FrequencyCapFilters#AD_EVENT_TYPE_WIN}, {@link android.adservices.common.FrequencyCapFilters#AD_EVENT_TYPE_IMPRESSION}, {@link android.adservices.common.FrequencyCapFilters#AD_EVENT_TYPE_VIEW}, {@link android.adservices.common.FrequencyCapFilters#AD_EVENT_TYPE_CLICK}, android.adservices.common.FrequencyCapFilters.AD_EVENT_TYPE_MIN, or android.adservices.common.FrequencyCapFilters.AD_EVENT_TYPE_MAX
 */

public int getAdEventType() { throw new RuntimeException("Stub!"); }

/**
 * Gets the caller adtech entity's {@link android.adservices.common.AdTechIdentifier AdTechIdentifier}.
 *
 * <p>The adtech using this {@link android.adservices.adselection.UpdateAdCounterHistogramRequest UpdateAdCounterHistogramRequest} object must have enrolled
 * with the Privacy Sandbox and be allowed to act on behalf of the calling app. The specified
 * adtech is not required to be the same adtech as either the buyer which owns the rendered ad
 * or the seller which initiated the ad selection associated with the ID returned by {@link
 * #getAdSelectionId()}.
 *
 * <p>For more information about API requirements and exceptions, see {@link android.adservices.adselection.AdSelectionManager#updateAdCounterHistogram(android.adservices.adselection.UpdateAdCounterHistogramRequest,java.util.concurrent.Executor,android.os.OutcomeReceiver)  }.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.AdTechIdentifier getCallerAdTech() { throw new RuntimeException("Stub!"); }

/**
 * Checks whether the {@link android.adservices.adselection.UpdateAdCounterHistogramRequest UpdateAdCounterHistogramRequest} objects contain the same
 * information.
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/** Returns the hash of the {@link android.adservices.adselection.UpdateAdCounterHistogramRequest UpdateAdCounterHistogramRequest} object's data. */

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }
/** Builder for {@link android.adservices.adselection.UpdateAdCounterHistogramRequest UpdateAdCounterHistogramRequest} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param callerAdTech This value cannot be {@code null}.
 */

public Builder(long adSelectionId, int adEventType, @android.annotation.NonNull android.adservices.common.AdTechIdentifier callerAdTech) { throw new RuntimeException("Stub!"); }

/**
 * Sets the ad selection ID with which the rendered ad's events are associated.
 *
 * <p>See {@link #getAdSelectionId()} for more information.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.UpdateAdCounterHistogramRequest.Builder setAdSelectionId(long adSelectionId) { throw new RuntimeException("Stub!"); }

/**
 * Sets the ad event type which, along with an ad's counter keys, identifies which histogram
 * should be updated.
 *
 * <p>See {@link #getAdEventType()} for more information.
 
 * @param adEventType Value is android.adservices.common.FrequencyCapFilters.AD_EVENT_TYPE_INVALID, {@link android.adservices.common.FrequencyCapFilters#AD_EVENT_TYPE_WIN}, {@link android.adservices.common.FrequencyCapFilters#AD_EVENT_TYPE_IMPRESSION}, {@link android.adservices.common.FrequencyCapFilters#AD_EVENT_TYPE_VIEW}, {@link android.adservices.common.FrequencyCapFilters#AD_EVENT_TYPE_CLICK}, android.adservices.common.FrequencyCapFilters.AD_EVENT_TYPE_MIN, or android.adservices.common.FrequencyCapFilters.AD_EVENT_TYPE_MAX
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.UpdateAdCounterHistogramRequest.Builder setAdEventType(int adEventType) { throw new RuntimeException("Stub!"); }

/**
 * Sets the caller adtech entity's {@link android.adservices.common.AdTechIdentifier AdTechIdentifier}.
 *
 * <p>See {@link #getCallerAdTech()} for more information.
 
 * @param callerAdTech This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.UpdateAdCounterHistogramRequest.Builder setCallerAdTech(@android.annotation.NonNull android.adservices.common.AdTechIdentifier callerAdTech) { throw new RuntimeException("Stub!"); }

/**
 * Builds the {@link android.adservices.adselection.UpdateAdCounterHistogramRequest UpdateAdCounterHistogramRequest} object.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.UpdateAdCounterHistogramRequest build() { throw new RuntimeException("Stub!"); }
}

}

