/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.adservices.topics;

import java.util.List;

/** Represent the result from the getTopics API. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class GetTopicsResponse {

GetTopicsResponse() { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@link java.util.List List} of {@link android.adservices.topics.Topic Topic} objects returned by getTopics API.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.adservices.topics.Topic> getTopics() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
/**
 * Builder for {@link android.adservices.topics.GetTopicsResponse GetTopicsResponse} objects. This class should be used in test
 * implementation as expected response from Topics API
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Creates a {@link android.adservices.topics.GetTopicsResponse.Builder Builder} for {@link android.adservices.topics.GetTopicsResponse GetTopicsResponse} objects.
 *
 * @param topics The list of the returned Topics.

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull java.util.List<android.adservices.topics.Topic> topics) { throw new RuntimeException("Stub!"); }

/**
 * Builds a {@link android.adservices.topics.GetTopicsResponse GetTopicsResponse} instance.
 *
 * <p>throws IllegalArgumentException if any of the params are null or there is any mismatch
 * in the size of ModelVersions and TaxonomyVersions.
 */

@android.annotation.NonNull
public android.adservices.topics.GetTopicsResponse build() { throw new RuntimeException("Stub!"); }
}

}

