/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SearchSpec implements android.os.Parcelable {

SearchSpec() { throw new RuntimeException("Stub!"); }

public final int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getAdvancedRankingExpression() { throw new RuntimeException("Stub!"); }

public int getDefaultEmbeddingSearchMetricType() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.app.appsearch.EmbeddingVector> getEmbeddingParameters() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<java.lang.String> getFilterNamespaces() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<java.lang.String> getFilterPackageNames() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Map<java.lang.String,java.util.List<java.lang.String>> getFilterProperties() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<java.lang.String> getFilterSchemas() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<java.lang.String> getInformationalRankingExpressions() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.app.appsearch.JoinSpec getJoinSpec() { throw new RuntimeException("Stub!"); }

public int getMaxSnippetSize() { throw new RuntimeException("Stub!"); }

public int getOrder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Map<java.lang.String,java.util.List<android.app.appsearch.PropertyPath>> getProjectionPaths() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Map<java.lang.String,java.util.List<java.lang.String>> getProjections() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Map<java.lang.String,java.util.Map<android.app.appsearch.PropertyPath,java.lang.Double>> getPropertyWeightPaths() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Map<java.lang.String,java.util.Map<java.lang.String,java.lang.Double>> getPropertyWeights() { throw new RuntimeException("Stub!"); }

public int getRankingStrategy() { throw new RuntimeException("Stub!"); }

public int getResultCountPerPage() { throw new RuntimeException("Stub!"); }

public int getResultGroupingLimit() { throw new RuntimeException("Stub!"); }

public int getResultGroupingTypeFlags() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getSearchSourceLogTag() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<java.lang.String> getSearchStringParameters() { throw new RuntimeException("Stub!"); }

public int getSnippetCount() { throw new RuntimeException("Stub!"); }

public int getSnippetCountPerProperty() { throw new RuntimeException("Stub!"); }

public int getTermMatch() { throw new RuntimeException("Stub!"); }

public boolean isListFilterHasPropertyFunctionEnabled() { throw new RuntimeException("Stub!"); }

public boolean isListFilterQueryLanguageEnabled() { throw new RuntimeException("Stub!"); }

public boolean isNumericSearchEnabled() { throw new RuntimeException("Stub!"); }

public boolean isVerbatimSearchEnabled() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.app.appsearch.SearchSpec> CREATOR;
static { CREATOR = null; }

public static final int EMBEDDING_SEARCH_METRIC_TYPE_COSINE = 1; // 0x1

public static final int EMBEDDING_SEARCH_METRIC_TYPE_DEFAULT = 0; // 0x0

public static final int EMBEDDING_SEARCH_METRIC_TYPE_DOT_PRODUCT = 2; // 0x2

public static final int EMBEDDING_SEARCH_METRIC_TYPE_EUCLIDEAN = 3; // 0x3

public static final int GROUPING_TYPE_PER_NAMESPACE = 2; // 0x2

public static final int GROUPING_TYPE_PER_PACKAGE = 1; // 0x1

public static final int GROUPING_TYPE_PER_SCHEMA = 4; // 0x4

public static final int ORDER_ASCENDING = 1; // 0x1

public static final int ORDER_DESCENDING = 0; // 0x0

@Deprecated public static final java.lang.String PROJECTION_SCHEMA_TYPE_WILDCARD = "*";

public static final int RANKING_STRATEGY_ADVANCED_RANKING_EXPRESSION = 9; // 0x9

public static final int RANKING_STRATEGY_CREATION_TIMESTAMP = 2; // 0x2

public static final int RANKING_STRATEGY_DOCUMENT_SCORE = 1; // 0x1

public static final int RANKING_STRATEGY_JOIN_AGGREGATE_SCORE = 8; // 0x8

public static final int RANKING_STRATEGY_NONE = 0; // 0x0

public static final int RANKING_STRATEGY_RELEVANCE_SCORE = 3; // 0x3

public static final int RANKING_STRATEGY_SYSTEM_USAGE_COUNT = 6; // 0x6

public static final int RANKING_STRATEGY_SYSTEM_USAGE_LAST_USED_TIMESTAMP = 7; // 0x7

public static final int RANKING_STRATEGY_USAGE_COUNT = 4; // 0x4

public static final int RANKING_STRATEGY_USAGE_LAST_USED_TIMESTAMP = 5; // 0x5

public static final java.lang.String SCHEMA_TYPE_WILDCARD = "*";

public static final int TERM_MATCH_EXACT_ONLY = 1; // 0x1

public static final int TERM_MATCH_PREFIX = 2; // 0x2
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addEmbeddingParameters(@android.annotation.NonNull android.app.appsearch.EmbeddingVector... searchEmbeddings) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addEmbeddingParameters(@android.annotation.NonNull java.util.Collection<android.app.appsearch.EmbeddingVector> searchEmbeddings) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterNamespaces(@android.annotation.NonNull java.lang.String... namespaces) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterNamespaces(@android.annotation.NonNull java.util.Collection<java.lang.String> namespaces) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterPackageNames(@android.annotation.NonNull java.lang.String... packageNames) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterPackageNames(@android.annotation.NonNull java.util.Collection<java.lang.String> packageNames) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterProperties(@android.annotation.NonNull java.lang.String schema, @android.annotation.NonNull java.util.Collection<java.lang.String> propertyPaths) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterPropertyPaths(@android.annotation.NonNull java.lang.String schema, @android.annotation.NonNull java.util.Collection<android.app.appsearch.PropertyPath> propertyPaths) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterSchemas(@android.annotation.NonNull java.lang.String... schemas) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterSchemas(@android.annotation.NonNull java.util.Collection<java.lang.String> schemas) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addInformationalRankingExpressions(@android.annotation.NonNull java.lang.String... informationalRankingExpressions) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addInformationalRankingExpressions(@android.annotation.NonNull java.util.Collection<java.lang.String> informationalRankingExpressions) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addProjection(@android.annotation.NonNull java.lang.String schema, @android.annotation.NonNull java.util.Collection<java.lang.String> propertyPaths) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addProjectionPaths(@android.annotation.NonNull java.lang.String schema, @android.annotation.NonNull java.util.Collection<android.app.appsearch.PropertyPath> propertyPaths) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addSearchStringParameters(@android.annotation.NonNull java.lang.String... searchStringParameters) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addSearchStringParameters(@android.annotation.NonNull java.util.List<java.lang.String> searchStringParameters) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setDefaultEmbeddingSearchMetricType(int defaultEmbeddingSearchMetricType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setJoinSpec(@android.annotation.NonNull android.app.appsearch.JoinSpec joinSpec) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setListFilterHasPropertyFunctionEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setListFilterQueryLanguageEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setMaxSnippetSize(int maxSnippetSize) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setNumericSearchEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setOrder(int order) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setPropertyWeightPaths(@android.annotation.NonNull java.lang.String schemaType, @android.annotation.NonNull java.util.Map<android.app.appsearch.PropertyPath,java.lang.Double> propertyPathWeights) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setPropertyWeights(@android.annotation.NonNull java.lang.String schemaType, @android.annotation.NonNull java.util.Map<java.lang.String,java.lang.Double> propertyPathWeights) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setRankingStrategy(int rankingStrategy) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setRankingStrategy(@android.annotation.NonNull java.lang.String advancedRankingExpression) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setResultCountPerPage(int resultCountPerPage) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setResultGrouping(int groupingTypeFlags, int limit) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setSearchSourceLogTag(@android.annotation.NonNull java.lang.String searchSourceLogTag) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setSnippetCount(int snippetCount) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setSnippetCountPerProperty(int snippetCountPerProperty) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setTermMatch(int termMatchType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setVerbatimSearchEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }
}

}

