/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.app.appsearch;

import java.util.Map;

/**
 * Provides results for AppSearch batch operations which encompass multiple documents.
 *
 * <p>Individual results of a batch operation are separated into two maps: one for successes and one
 * for failures. For successes, {@link #getSuccesses()} will return a map of keys to instances of
 * the value type. For failures, {@link #getFailures()} will return a map of keys to {@link android.app.appsearch.AppSearchResult AppSearchResult} objects.
 *
 * <p>Alternatively, {@link #getAll()} returns a map of keys to {@link android.app.appsearch.AppSearchResult AppSearchResult} objects for
 * both successes and failures.
 *
 * @param <KeyType> The type of the keys for which the results will be reported.
 * @param <ValueType> The type of the result objects for successful results.
 * @see android.app.appsearch.AppSearchSession#put
 * @see android.app.appsearch.AppSearchSession#getByDocumentId
 * @see AppSearchSession#remove
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class AppSearchBatchResult<KeyType, ValueType> {

AppSearchBatchResult() { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@link java.util.Map Map} of keys mapped to instances of {@link android.app.appsearch.AppSearchResult AppSearchResult} for all
 * individual results.
 *
 * <p>The values of the {@link java.util.Map Map} will not be {@code null}.
 */

@android.annotation.NonNull
public java.util.Map<KeyType,android.app.appsearch.AppSearchResult<ValueType>> getAll() { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@link java.util.Map Map} of keys mapped to instances of {@link android.app.appsearch.AppSearchResult AppSearchResult} for all failed
 * individual results.
 *
 * <p>The values of the {@link java.util.Map Map} will not be {@code null}.
 */

@android.annotation.NonNull
public java.util.Map<KeyType,android.app.appsearch.AppSearchResult<ValueType>> getFailures() { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@link java.util.Map Map} of keys mapped to instances of the value type for all successful
 * individual results.
 *
 * <p>Example: {@link android.app.appsearch.AppSearchSession#getByDocumentId AppSearchSession.getByDocumentId} returns an {@link android.app.appsearch.AppSearchBatchResult AppSearchBatchResult}.
 * Each key (the document ID, of {@code String} type) will map to a {@link android.app.appsearch.GenericDocument GenericDocument}
 * object.
 *
 * <p>The values of the {@link java.util.Map Map} will not be {@code null}.
 */

@android.annotation.NonNull
public java.util.Map<KeyType,ValueType> getSuccesses() { throw new RuntimeException("Stub!"); }

/** Returns {@code true} if this {@link android.app.appsearch.AppSearchBatchResult AppSearchBatchResult} has no failures. */

public boolean isSuccess() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }
/**
 * Builder for {@link android.app.appsearch.AppSearchBatchResult AppSearchBatchResult} objects.
 *
 * @param <KeyType> The type of the keys for which the results will be reported.
 * @param <ValueType> The type of the result objects for successful results.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder<KeyType, ValueType> {

/** Creates a new {@link android.app.appsearch.AppSearchBatchResult.Builder Builder}. */

public Builder() { throw new RuntimeException("Stub!"); }

/** Creates a new {@link android.app.appsearch.AppSearchBatchResult.Builder Builder} from the given {@link android.app.appsearch.AppSearchBatchResult AppSearchBatchResult}. */

public Builder(@android.annotation.NonNull android.app.appsearch.AppSearchBatchResult<KeyType,ValueType> appSearchBatchResult) { throw new RuntimeException("Stub!"); }

/**
 * Builds an {@link android.app.appsearch.AppSearchBatchResult AppSearchBatchResult} object from the contents of this {@link android.app.appsearch.AppSearchBatchResult.Builder Builder}.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchBatchResult<KeyType,ValueType> build() { throw new RuntimeException("Stub!"); }

/**
 * Associates the {@code key} with the provided failure code and error message.
 *
 * <p>Any previous mapping for a key, whether success or failure, is deleted.
 *
 * <p>This is a convenience function which is equivalent to {@code setResult(key,
 * AppSearchResult.newFailedResult(resultCode, errorMessage))}.
 *
 * @param key The key to associate the result with; usually corresponds to some identifier
 *     from the input like an ID or name.
 * @param resultCode One of the constants documented in {@link android.app.appsearch.AppSearchResult#getResultCode      }.
 * Value is {@link android.app.appsearch.AppSearchResult#RESULT_OK}, {@link android.app.appsearch.AppSearchResult#RESULT_UNKNOWN_ERROR}, {@link android.app.appsearch.AppSearchResult#RESULT_INTERNAL_ERROR}, {@link android.app.appsearch.AppSearchResult#RESULT_INVALID_ARGUMENT}, {@link android.app.appsearch.AppSearchResult#RESULT_IO_ERROR}, {@link android.app.appsearch.AppSearchResult#RESULT_OUT_OF_SPACE}, {@link android.app.appsearch.AppSearchResult#RESULT_NOT_FOUND}, {@link android.app.appsearch.AppSearchResult#RESULT_INVALID_SCHEMA}, {@link android.app.appsearch.AppSearchResult#RESULT_SECURITY_ERROR}, {@link android.app.appsearch.AppSearchResult#RESULT_DENIED}, {@link android.app.appsearch.AppSearchResult#RESULT_RATE_LIMITED}, android.app.appsearch.AppSearchResult.RESULT_TIMED_OUT, or {@link android.app.appsearch.AppSearchResult#RESULT_ALREADY_EXISTS}
 * @param errorMessage An optional string describing the reason or nature of the failure.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchBatchResult.Builder<KeyType,ValueType> setFailure(@android.annotation.NonNull KeyType key, int resultCode, @android.annotation.Nullable java.lang.String errorMessage) { throw new RuntimeException("Stub!"); }

/**
 * Associates the {@code key} with the provided {@code result}.
 *
 * <p>Any previous mapping for a key, whether success or failure, is deleted.
 *
 * @param key The key to associate the result with; usually corresponds to some identifier
 *     from the input like an ID or name.
 * @param result The result to associate with the key.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchBatchResult.Builder<KeyType,ValueType> setResult(@android.annotation.NonNull KeyType key, @android.annotation.NonNull android.app.appsearch.AppSearchResult<ValueType> result) { throw new RuntimeException("Stub!"); }

/**
 * Associates the {@code key} with the provided successful return value.
 *
 * <p>Any previous mapping for a key, whether success or failure, is deleted.
 *
 * <p>This is a convenience function which is equivalent to {@code setResult(key,
 * AppSearchResult.newSuccessfulResult(value))}.
 *
 * @param key The key to associate the result with; usually corresponds to some identifier
 *     from the input like an ID or name.
 * @param value An optional value to associate with the successful result of the operation
 *     being performed.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchBatchResult.Builder<KeyType,ValueType> setSuccess(@android.annotation.NonNull KeyType key, @android.annotation.Nullable ValueType value) { throw new RuntimeException("Stub!"); }
}

}

