/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;


/**
 * An identifier to represent a blob in AppSearch.
 *
 * <p>A "blob" is a large binary object. It is used to store a significant amount of data that is
 * not searchable, such as images, videos, audio files, or other binary data. Unlike other fields in
 * AppSearch, blobs are stored as blob files on disk rather than in memory, and use {@link
 * android.os.ParcelFileDescriptor} to read and write. This allows for efficient handling of large,
 * non-searchable content.
 *
 * <p>{@link android.app.appsearch.AppSearchBlobHandle AppSearchBlobHandle} is a light-weight {@code Property} of {@link android.app.appsearch.GenericDocument GenericDocument},
 * which is a pointer to the heavy-weight blob data.
 *
 * <p>The blob data could be written via {@link android.app.appsearch.AppSearchSession#openBlobForWrite AppSearchSession.openBlobForWrite} and read via
 * {@link android.app.appsearch.AppSearchSession#openBlobForRead AppSearchSession.openBlobForRead}.
 *
 * <p>A {@link android.app.appsearch.GenericDocument GenericDocument} with {@link android.app.appsearch.AppSearchBlobHandle AppSearchBlobHandle} {@code Property} could be put and
 * read without the large blob data. This offers lazy retrieval to blob data when searching {@link android.app.appsearch.GenericDocument GenericDocument} in AppSearch.
 *
 * @see android.app.appsearch.GenericDocument.Builder#setPropertyBlobHandle
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class AppSearchBlobHandle implements android.os.Parcelable {

AppSearchBlobHandle() { throw new RuntimeException("Stub!"); }

/**
 * Create a new AppSearch blob identifier with given digest, package, database and namespace.
 *
 * <p>The package name and database name indicated where this blob will be stored. To write,
 * commit or read this blob via {@link android.app.appsearch.AppSearchSession AppSearchSession}, it must match the package name and
 * database name of {@link android.app.appsearch.AppSearchSession AppSearchSession}.
 *
 * <p>For two objects of {@link android.app.appsearch.AppSearchBlobHandle AppSearchBlobHandle} to be considered equal, the {@code
 * packageName}, {@code database}, {@code namespace} and {@code digest} must be equal.
 *
 * @param digest The SHA-256 hash of the blob this is representing.
 * This value cannot be {@code null}.
 * @param packageName The package name of the owner of this Blob.
 * This value cannot be {@code null}.
 * @param databaseName The database name of this blob to stored into.
 * This value cannot be {@code null}.
 * @param namespace The namespace of this blob resides in.
 * This value cannot be {@code null}.
 * @return a new instance of {@link android.app.appsearch.AppSearchBlobHandle AppSearchBlobHandle} object.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static android.app.appsearch.AppSearchBlobHandle createWithSha256(@android.annotation.NonNull byte[] digest, @android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull java.lang.String databaseName, @android.annotation.NonNull java.lang.String namespace) { throw new RuntimeException("Stub!"); }

/** @hide */

public final int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the name of database stored the blob that this object is representing.
 *
 * <p>For two objects of {@link android.app.appsearch.AppSearchBlobHandle AppSearchBlobHandle} to be considered equal, the {@code
 * packageName}, {@code database}, {@code namespace} and {@code digest} must be equal.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getDatabaseName() { throw new RuntimeException("Stub!"); }

/**
 * Returns the app-defined namespace this blob resides in.
 *
 * <p>For two objects of {@link android.app.appsearch.AppSearchBlobHandle AppSearchBlobHandle} to be considered equal, the {@code
 * packageName}, {@code database}, {@code namespace} and {@code digest} must be equal.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getNamespace() { throw new RuntimeException("Stub!"); }

/**
 * Returns the package name indicating the owner app of the blob that this object is
 * representing.
 *
 * <p>For two objects of {@link android.app.appsearch.AppSearchBlobHandle AppSearchBlobHandle} to be considered equal, the {@code
 * packageName}, {@code database}, {@code namespace} and {@code digest} must be equal.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getPackageName() { throw new RuntimeException("Stub!"); }

/**
 * Returns the SHA-256 hash of the blob that this object is representing.
 *
 * <p>For two objects of {@link android.app.appsearch.AppSearchBlobHandle AppSearchBlobHandle} to be considered equal, the {@code
 * packageName}, {@code database}, {@code namespace} and {@code digest} must be equal.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public byte[] getSha256Digest() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.app.appsearch.AppSearchBlobHandle> CREATOR;
static { CREATOR = null; }
}

